﻿'http://www.facebook.com/GtaIVScripting
'https://www.youtube.com/user/GTAScripting

'Air Combat IV script by JulioNIB

'with colaboration (testing/jet models/tips/code tips) of:

'core.max2010 - https://www.youtube.com/user/coremax2010
'metalwars - https://www.youtube.com/user/Metalwarz
'SkylineGTRFreak - https://www.youtube.com/user/SkylineGTRR34Freak
'zzcool (taltigolt) - https://www.youtube.com/user/taltigolt
'Hardsty1e - http://www.gtagaming.com/forums/member.php?u=107738
'Fredwalktrought - https://www.youtube.com/user/fredwalkthrough

Imports System
Imports GTA
Imports System.Windows.Forms
Imports System.Drawing
Imports System.Collections.Generic
Imports System.IO
Imports System.Text

Public Class AirCombat_IV
    Inherits Script

    Private timeWaitLoadsettings As Double = 500
    Private iniFile As String = ""
    Private soundAuxIdle As gta.object
    Private soundAuxAceel As gta.object
    Private soundAuxAceel2 As gta.object
    Private soundOffset As Double = 0
    Private soundOffsetAux As Double = 0
    Private ptfxEject As int32
    Private multi As Double = 1
    Private multiAux As Double = 0
    Private lastJetHealth As Double = 1000
    Private myJet As vehicle = Nothing
    Private myFakeJet As vehicle = Nothing
    Private actual20mm As int16 = 0
    Private dot20mmPTFX As int32 = 0
    Private dot20mmPTFXTrace As int32 = 0
    'private planeDirAuxFront as gta.object = nothing
    'private planeDirAuxCenter as gta.object = nothing
    'private planeDirAuxUp as gta.object = nothing
    Private currWeapon As int16 = 0
    Private timeShoot20mm As int16 = 0
    Private trainList As New list(Of trains)
    Private trainListAux As New list(Of trains)
    Private trainItem As trains
    Private bResetPL As Boolean = False
    Private timeWaitSoundRocket As Double = 0
    Private original_model As model = Nothing
    Private PTFXMyJetSmoke As int32 = 0
    Private PTFXMyJetFire As int32 = 0
    'private timeReloadSettings as double = 0
    Private rpmAnim As Double = 0
    Private width_Coef, height_Coef As Double
    Private myWidth, myHeight, myGameWidth, myGameHeight As Int16
    Private groundZ As Double
    Private PTFXMyExp As int32
    Private bExplodeMyJet As Boolean = True
    Private PTFXWater As int32 = 0
    Private timeWaterEffect As Double = 0
    Private timeKeepWaterEffect As Double = 0
    Private actualJetSpeed As Double = 40
    Private bWaterImpact As Boolean = False
    Private timeWaitCloseGears As Double = 0
    Private timeWaitOpenGears As Double = 0
    Private timeSearchIdleJets As Double = 5000
    Private bWarnEnemyMissileLock As Boolean = False
    Private bWarnMyMissileLock As Boolean = False
    Private bPlayerWasAlive As Boolean = True
    Private st_height_teleport, st_height_teleport_back, st_time_check, st_time_check_aux As Double
    Private st_teleport_pos, st_teleport_pos_back As vector3
    Private st_in_earth As Boolean = True
    Private camPilotOffset As vector3
    Private camPilotDir As vector3
    Private camPilotOriginalDir As vector3
    Private camPilotOriginalPlaneDir As vector3
    Private camPilotHidePlayer As Boolean = False
    Private camPilotFixedRotation As Boolean = False
    Private timeResetPlayerInv As Double = 0
    Private moveForceMultAux As Double = 0.1
    Private bSpawnMenuON As Boolean = False
    Private bFixedCockpitCam As Boolean = True
    Private camObjectAux As GTA.Object = Nothing
	private bMustStop as boolean = false
	
    ' dificult level
    Private timeWaitMissileLock As Double = 300 ' this will decrease when you kill enemies
    Private AimEase As Double = 1 ' greater = easier

    ' setup mode
    Private SM_Current_index As Int16 = 0
    Private SM_Obj_aux As GTA.Object = Nothing
    Private SM_actual_rocket As Int16 = 0
    Private SM_actual_cannon As Int16 = 0
    Private SM_actual_engine As Int16 = 0
    Private SM_type As Int16 = 0
    Private SM_TimeWaitPTFX As Double = 50

    ' hotkeys
    Private hkShootRocket, hkShootCannon, hkDropBomb, hkSwitchGun, hkSpawnEnemy, hkSpawnFugitive, hkJetMoveDown, hkJetMoveUp, _
        hkEject, hkEnterJet, hkSwitchCam, hkFlare, hkTurnLeft, hkTurnRight, hkRollLeft, hkRollRight, hkUp, hkDown, hkSpawnMenu, _
        hkNextMenuItem, hkPrevMenuItem As keys

    Private bFlapsHelpMode As Boolean = False
    Private bShowPosition As Boolean = False
    Private bSetupHelpMode As Boolean = False

    ' sounds
    Private sndRocket As New System.Media.SoundPlayer()
    Private sndEject As New System.Media.SoundPlayer()
    Private sndAlarm As New System.Media.SoundPlayer()
    Private sndMissileLock As New System.Media.SoundPlayer()
    Private sndRocket2 As New System.Media.SoundPlayer()
    Private sndAlarm2 As New System.Media.SoundPlayer()
    Private sndMissileLock2 As New System.Media.SoundPlayer()
    ' native sonds section
    Private IDsndCannon As int32 = 0
    Private IDSndJetIdle As int32 = 0
    Private IDSndJetAccel As int32 = 0
    Private IDSndJetAccel2 As int32 = 0
    Private IDSndBombRelease As int32 = 0
    Private IDsndRocketMove As int32 = 0
    Private IDsndRocketMoveEnemy As int32 = 0
    Private timeWaitIDSndJetAccel As Double = 0

    ' extra cams
    Private camDeath As camera
    Private camGun As camera
    Private camMode As Int16 = 0
    Private bRocketCamON As Boolean = False

    ' rocket	
    Private Class MR
        Public enabled As Boolean = False
        Public rocket As GTA.Object
        Public model_name As String = "cj_rpg_rocket"
        Public dir As vector3
        Public final_dir As vector3 = vector3.zero
        Public launched As Boolean = False
        Public attached As Boolean = False
        Public timeOut As Double = 0
        Public ptfxID As int32 = 0
        Public ptfxExpID As int32 = 0
        Public ROff As int32 = 0
        Public xAttach, yAttach, zAttach, xRotAttach, yRotAttach, zRotAttach As Double
        Public isBomb As Boolean = False
        Public visible_fired As Boolean = True
        Public visible_idle As Boolean = True
        Public speed_multiplier As Double = 1.0
        Public explosion_size As Double = 1.0
        Public explosion_force As Double = 1.0
        Public propulsor_effect_size As Double = 1.0
        Public timeResetPTFX As Double = 0
        Public damage_against_jets As Double
        Public fixRotation As vector3
        Public TRocketsJetLocked As TJet = Nothing
        Public THeliLocked As Vehicle = Nothing
        Public bReseting As Boolean = False

        Public Sub Hide(ByVal rocket As gta.object)
            rocket.detach()
            rocket.visible = False
            rocket.freezeposition = True
            native.function.call("SET_OBJECT_COLLISION", rocket, False)
        End Sub

        Public Sub attach(ByVal jet As Vehicle)
            Native.Function.Call("SET_OBJECT_COLLISION", rocket, False)
            Native.Function.Call("SET_OBJECT_RECORDS_COLLISIONS", rocket, 0)
            Native.Function.Call("stop_ptfx", ptfxID)
            rocket.FreezePosition = False
            Native.Function.Call("ATTACH_OBJECT_TO_CAR", rocket, jet, 0, xAttach, yAttach, zAttach, 0, 0, 0)
            rocket.Visible = visible_idle
            Native.Function.Call("SET_OBJECT_DYNAMIC", rocket, 1)
            final_dir = Vector3.Zero
            launched = False
            attached = True
            TRocketsJetLocked = Nothing
            bReseting = False
        End Sub

        Public Function launch(ByVal pDir As vector3, ByVal bJetLocked As Boolean)
            If launched Then Return False

            native.function.call("SET_OBJECT_COLLISION", rocket, True)

            rocket.freezeposition = False
            launched = True
            attached = False
            timeOut = 1000

            dir = pDir

            If bJetLocked Then
                final_dir = pDir
            Else
                final_dir = vector3.zero
            End If

            If propulsor_effect_size > 0 Then
                Native.Function.Call("stop_ptfx", ptfxID)

                ptfxID = Native.Function.Call(Of Int32)("START_PTFX_ON_OBJ", "weap_rocket_player", rocket, 0, 0, 0, 0, 0, 0, propulsor_effect_size)
            End If

            fixRotation = rocket.rotation

            rocket.detach()

            native.function.call("SET_OBJECT_RECORDS_COLLISIONS", rocket, 1)

            rocket.visible = visible_fired

            Return True
        End Function
    End Class

    Private tmpRocket As MR
    Private TJetLocked As TJet = Nothing
    Private jetEnemyAttacking As vehicle = Nothing
    Private myRockets As New list(Of gta.Object)

    ' cannon
    Private Class cannon
        Public enabled As Boolean = False
        Public size As Double = 1.0
        Public trace_size As Double = 1.0
        Public damage As Integer = 10
        'public x, y, z as double
        Public range As Double = 300
        Public shootTime As int16 = 1
        Public ptfx As int32 = 0
        Public ptfxTrace As int32 = 0
        'public attachPoint as gta.object = nothing
        Public offPosition As vector3
    End Class

    Private tmpCannon As cannon
    'private cannList as new list(of cannon)
    'private actualCannon as int16 = 0
    'private cannonCount as int16 = 0

    ' textures/sprites
    Private texMissile As texture
    Private texBomb As texture
    Private texJet As texture
    Private texRpm As texture
    Private texMissileAlarm As texture
    Private texMissileLocked As texture
    Private texBackg As texture
    Private texLineAux As texture
    Private texBotton As texture
    Private texFlares As texture

    ' engine
    Private Class engine
        Public enabled As Boolean = False
        Public ptfx As int32 = 0
        Public engLight As light = New light
        Public offPosition As vector3
    End Class

    Private tmpEngine As engine

    ' enemy cfg
    Private enemyJet_shoot_cannon, enemyJet_shoot_rocket As Boolean
    Private enemyJet_cannon_dmg, enemyJet_rocket_damage, enemyJet_rocket_timewait, maxRoundForEvade, maxRoundForFugitiveEvade As int32
    Private maxAutoSpawnEnemies As int16 = 2
    Private timeLastAutoSpawnEnemies As Double = 0
    Private drawEnemyRectDist As Double = 350

    ' jets
    Private Class TJet
        Public jet As vehicle = Nothing
        Public p As ped = Nothing
        Public lastHealth As Double = 1000
        Public timeWait As int16 = 1000
        Public rockets As New list(Of MR)
        Private timeShoot20mm As int16 = 0
        Private dot20mmPTFX As int32 = 0
        Private dot20mmPTFXTrace As int32 = 0
        Private actual20mm As int16 = 0
        'public dirObj as gta.object = nothing
        'public dirObjCenter as gta.object = nothing
        Public PTFXFire As int32 = 0
        Public PTFXSmoke As int32 = 0
        Public PTFXExp As int32 = 0
        Public timeRemove As int16 = -1000
        Public jetblip As blip = Nothing
        Public timeWaitLaunch As Double = 0
        Public timeMissileAlarm As Double = 0
        Public timeMissileAlarmValue As Double = 300
        Public timeMissileLock As Double = 0
        Public timeMissileLockValue As Double = 300
        Public is_hunter As Boolean = False
        Public is_fugitive As Boolean = False
        Public isMP As Boolean = False
        Public bAutoSpawn As Boolean = False
        Public engines As New list(Of engine)
        Public bExplodeJet As Boolean = True
        Public lockedOnTarget As Boolean = False
        Public timeOutFlare As Double = 0
        Public flareReleased As Boolean = False
        Public timeResetRot As Double = 100
        Public resetRot As vector3 = vector3.zero
        Public resetHeading As Double = 0
        Public resetSpeed As Double = 0
        Public actualSpeed As Double
        Public checkPAux As Checkpoint = New Checkpoint
        Public DamagedByPlayer As Boolean = False

        Public back_gear_l As int16
        Public back_gear_r As int16
        Public front_gear_l As int16
        Public front_gear_r As int16
        Public flaps_r As int16
        Public flaps_l As int16
        Public flap_idle_angle As Double
        Public gears_closed_angle As Double

        Public Sub start()
            jet.enginerunning = True
            p.becomemissioncharacter()
            jet.applyforce(vector3.worldup * 5)
            jet.speed = 50.0
            jetblip = jet.attachblip

            If is_hunter Then
                jetBlip.color = blipcolor.red
            Else
                jetBlip.color = blipcolor.yellow
            End If

            resetRot = vector3.zero
            resetHeading = 0
            resetSpeed = 0
            timeResetRot = 100

            actualSpeed = 100
        End Sub

        Public Sub shoot20mm(ByVal vecPosFin As Vector3, ByVal dmg As Int32)
            If Me.timeShoot20mm <= 0 Then
                Me.timeShoot20mm = 10

                Native.Function.Call("stop_ptfx", Me.dot20mmPTFX)
                Native.Function.Call("stop_ptfx", Me.dot20mmPTFXTrace)

                If Me.actual20mm = 1 Then
                    Me.dot20mmPTFX = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "muz_machine", _
                        jet, 0.85, 2.0, -0.3, 0, 0, 90.0, 2.0)
                    Me.dot20mmPTFXTrace = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "wpn_bullet_trace", _
                        jet, 0.85, 2.0, -0.3, -90.0, 0, 0, 3.0)
                Else
                    Me.dot20mmPTFX = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "muz_machine", _
                        jet, -0.85, 2.0, -0.3, 0, 0, 90.0, 2.0)
                    Me.dot20mmPTFXTrace = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "wpn_bullet_trace", _
                        jet, -0.85, 2.0, -0.3, -90.0, 0, 0, 3.0)
                End If

                Dim vecPos As Vector3 = Me.jet.Position + Me.jet.Direction * 5

                Native.Function.Call("FIRE_SINGLE_BULLET", vecPos.X, vecPos.Y, vecPos.Z, vecPosFin.X, vecPosFin.Y, vecPosFin.Z, dmg)

                Me.actual20mm += 1

                If Me.actual20mm > 1 Then Me.actual20mm = 0
            Else
                Me.timeShoot20mm -= 10 * (25 / Game.FPS)
            End If
        End Sub
    End Class

    ' custom jet config
    Private Class TCustomJetCFG
        Public jetModel As model

        Public fileName As String

        Public display_name As String
        'public hotKeySpawn as keys
        Public console_cmd_spawn As String

        Public pilot_model As model
        Public enemy_model As Model
        Public sEnemy_model As String
        Public maxJetSpeed As Double
        Public use_fake_jet As Boolean

        Public engineList As New list(Of engine)
        Public engineMinFxSize, engineIdleFxSize, engineMaxFxSize

        Public cannList As New list(Of cannon)
        Public actualCannon As int16 = 0
        Public cannonCount As int16 = 0

        Public MRL As New List(Of MR)
        Public MRLReset As New List(Of MR)

        Public cam1_ahead_Offset, cam1_up_offset, _
            cam2_ahead_Offset, cam2_up_offset, _
            cam3_ahead_Offset, cam3_up_offset As Double

        Public soundCannon, soundJetIdle, soundJetAccel, soundJetAccel2, soundBombRelease, soundRocketMove As String

        Public wingsAngle As Double = 20
        Public maxWingAngle As Double = 0
        Public idleFlapsAngle, minFlapsAngle, maxFlapsAngle, rudder_idle_angle, rudder_min_angle, rudder_max_angle, gears_closed_angle, gears_open_angle, elevator_idle_angle, elevator_min_angle, elevator_max_angle As Double
        Public cockpit_id, left_wing_id, right_wing_id, left_flap_id, right_flap_id, back_gears_r_id, back_gears_l_id, front_gears_r_id, front_gears_l_id, rudder_1_id, rudder_2_id, elevator_1_id, elevator_2_id As int16

        Public moveLeftForce, moveRightForce, rollLeftForce, rollRightForce, moveUpForce, moveDownForce As Double

        Public texPreview As Texture = Nothing
    End Class

    Private tmpTCustomJetCFG As TCustomJetCFG
    Private TCustomJetCFGList As New List(Of TCustomJetCFG)
    Private myActualJet As TCustomJetCFG = Nothing

    ' enemy models
    Private Class EnemyModel
        Public model As String
        Public jet_model As int16
        Public back_gear_l As int16
        Public back_gear_r As int16
        Public front_gear_l As int16
        Public front_gear_r As int16
        Public flaps_r As int16
        Public flaps_l As int16
        Public flap_idle_angle As Double
        Public gears_closed_angle As Double
    End Class

    Private tmpEnemyModel As EnemyModel
    'Private enemyModels As New list(Of EnemyModel)

    ' my flare
    'private myFlareObj as gta.object = nothing
    'private PTFXMyFlare as int32
    Private timeOutMyFlare As Double = 0
    Private myFlareReleased As Boolean = False
    Private timeHKFlareDown As Double = 0
    Private timeWaitNextRelFlare As Double = 0
    Private timeShowFlareAux As Double = 0

    ' flares aux
    Private Class Flare
        Public flareObj As gta.object = Nothing
        Public PTFXFlare As int32 = 0
    End Class

    Private tmpFlare As flare
    Private myFlares As New List(Of Flare)
    Private myFlaresResetList As New List(Of Flare)
    Private enemyFlares As New List(Of Flare)
    Private timeWaitResetFlarePTFX As Double = 0

    Private tmpJet As TJet
    Private jetList As New list(Of TJet)
    'private wreckedJetList as new list(of TJet)

    ' fake trains
    Private Class trains
        Public pos, rot, vel As vector3
        Public m As model
        Public train As gta.object
        Public bCreate As Boolean = True
        Public speed As Double

        Public Sub New(ByVal v As gta.vehicle)
            pos = v.position
            rot = v.rotation
            speed = v.speed
            m = v.model
            train = Nothing
        End Sub
    End Class

    ' helicopters	
    Private Class THeli
        Public heli As vehicle = Nothing
        Public heliBlip As blip = Nothing
        Public timeMissileLockValue As Double = 0
        Public timeMissileLock As Double = 0
        'Public checkPAux As checkpoint = New checkpoint
        Public isMP As Boolean = False

        Public Sub New(ByVal v As vehicle)
            heli = v
            heliBlip = v.attachblip
            heliBlip.color = blipcolor.Orange
        End Sub
    End Class

    Private tmpHeli As tHeli = Nothing
    Private heliList As New list(Of THeli)
    Private heliLocked As vehicle = Nothing
    Private timeCheckHeli As Double = 0

    ' jet aquirement point
    Private Class TJetAP
        Public diameter, heading As Double
        Public checkPos, jetPos As vector3
        Public cp As checkpoint = New checkpoint
        Public cpAlpha, cpRcolor, cpGcolor, cpBcolor As int16
        Public autoCreateJet As Boolean = False
        Public createdJet As vehicle = Nothing
        Public jetModel As model = Nothing
        Public resetPosition As Boolean = True
        Public checkPVisible As Boolean = True
        Public showOnMap As Boolean = True
        Public tblip As Blip = Nothing
        Public display_name As String = ""
    End Class

    Private tmpTJetAP As TJetAP = Nothing
    Private TJetAPList As New list(Of TJetAP)
    Private timeSetAP As Double = 1000

    Public Sub New()
        Me.interval = 10

        original_model = player.model
    End Sub

    Private Sub loadSettingsAux()
        game.console.print("Air Combat IV script by JulioNIB v1.4")

        soundAuxIdle = world.createobject("cj_proc_brick", player.character.position.around(23) + vector3.worldup * 7)
        soundAuxIdle.visible = False
        native.function.call("set_object_collision", soundAuxIdle, False)
        soundAuxAceel = world.createobject("cj_proc_brick", player.character.position.around(3) + vector3.worldup * 5)
        soundAuxAceel.visible = False
        native.function.call("set_object_collision", soundAuxAceel, False)
        soundAuxAceel2 = world.createobject("cj_proc_brick", player.character.position.around(4) + vector3.worldup * 7)
        soundAuxAceel2.visible = False
        native.function.call("set_object_collision", soundAuxAceel2, False)

        SM_Obj_aux = world.createobject("cj_proc_brick", player.character.position.around(5) + vector3.worldup * 7)
        SM_Obj_aux.visible = False
        Native.Function.Call("set_object_collision", SM_Obj_aux, False)

        camObjectAux = World.CreateObject("cj_proc_brick", Player.Character.Position.Around(6) + Vector3.WorldUp * 7)
        camObjectAux.Visible = False
        Native.Function.Call("set_object_collision", camObjectAux, False)

        texMissile = New texture(file.readallbytes(".\Scripts\JetFiles\missile.png"))
        texBomb = New texture(file.readallbytes(".\Scripts\JetFiles\bomb.png"))
        texJet = New texture(file.readallbytes(".\Scripts\JetFiles\jet.png"))
        texRpm = New texture(file.readallbytes(".\Scripts\JetFiles\speed.png"))
        texMissileAlarm = New texture(file.readallbytes(".\Scripts\JetFiles\missile_alarm.png"))
        texMissileLocked = New texture(file.readallbytes(".\Scripts\JetFiles\missileLocked.png"))
        texBackg = New texture(file.readallbytes(".\Scripts\JetFiles\Back.png"))
        texLineAux = New texture(file.readallbytes(".\Scripts\JetFiles\Line.png"))
        texBotton = New texture(file.readallbytes(".\Scripts\JetFiles\Botton.png"))
        texFlares = New texture(file.readallbytes(".\Scripts\JetFiles\Flare.png"))

        sndRocket.SoundLocation = ".\Scripts\JetFiles\rocketLaunch.wav"
        sndRocket.Load()
        sndEject.SoundLocation = ".\Scripts\JetFiles\eject.wav"
        sndEject.Load()
        sndAlarm.SoundLocation = ".\Scripts\JetFiles\alarm.wav"
        sndAlarm.Load()
        sndMissileLock.SoundLocation = ".\Scripts\JetFiles\missileLock.wav"
        sndMissileLock.Load()

        sndRocket2.SoundLocation = ".\Scripts\JetFiles\rocketLaunch2.wav"
        sndRocket2.Load()
        sndAlarm2.SoundLocation = ".\Scripts\JetFiles\alarm2.wav"
        sndAlarm2.Load()
        sndMissileLock2.SoundLocation = ".\Scripts\JetFiles\missileLock2.wav"
        sndMissileLock2.Load()

        IDSndJetIdle = native.function.call(Of int32)("get_sound_id")
        IDSndJetAccel = native.function.call(Of int32)("get_sound_id")
        IDSndJetAccel2 = native.function.call(Of int32)("get_sound_id")
        IDsndCannon = native.function.call(Of int32)("get_sound_id")
        IDsndBombRelease = native.function.call(Of int32)("get_sound_id")
        IDsndRocketMove = native.function.call(Of int32)("get_sound_id")
        IDsndRocketMoveEnemy = native.function.call(Of int32)("get_sound_id")

        myWidth = 1680
        myHeight = 1050

        ' load settings
        loadConfig()

        ' load custom jet settings
        loadJetConfig()

        ' load custom aquirement points
        loadJetAquirementPos()

        camDeath = New camera
        camGun = New camera
    End Sub

    Private Sub msg(ByVal sMsg As String, ByVal time As int32)
        Native.Function.Call("PRINT_STRING_WITH_LITERAL_STRING_NOW", "STRING", sMsg, time, 1)
    End Sub

    Private Sub keyDown(ByVal sender As Object, ByVal e As GTA.KeyEventArgs) Handles MyBase.KeyDown
        If bSetupHelpMode Then
            setupModeKeypress(e)

            Exit Sub
        End If

        If isInJet() AndAlso (e.Key = hkFlare) AndAlso (timeOutMyFlare <= 0) Then
            timeHKFlareDown = 0
            timeWaitNextRelFlare = 0
        End If

        If isInJet() AndAlso ((e.Key = hkSpawnEnemy) OrElse (e.Key = hkSpawnFugitive)) Then
            For c As Int16 = 1 To 3
                If spawnEnemyJet(e.Key) Then
                    Exit For
                Else
                    Wait(50)
                End If
            Next
        End If

        If isInJet() AndAlso (e.Key = hkSwitchCam) Then
            If Exists(camGun) Then
                camMode += 1

                ' rocket 1, 2, 3, ..., Bomb, cannon and normal cam
                If camMode > 5 Then camMode = 0

                If camMode = 4 Then
                    Player.Character.Visible = Not camPilotHidePlayer

                    Dim TmpSpeed As Double = myJet.Speed
                    myJet.FreezePosition = True
                    Wait(10)
                    camPilotOffset = myJet.GetOffset(Player.Character.GetOffsetPosition(Vector3.WorldUp * 0.7 + Player.Character.Direction * 0.06))
                    camPilotDir = myJet.Rotation
                    camPilotOriginalDir = myJet.Rotation
                    camPilotOriginalPlaneDir = myJet.Rotation
                    myJet.FreezePosition = False
                    Native.Function.Call("SET_CAR_FORWARD_SPEED", myJet, TmpSpeed)

                    bFixedCockpitCam = True
                Else
                    Player.Character.Visible = True
                End If

                If camMode > 0 Then
                    camGun.Activate()
                Else
                    camGun.Deactivate()
                End If
            Else
                msg("Error creating extra camera...", 3000)
            End If
        End If

        If isInJet() AndAlso (e.Key = hkSwitchGun) AndAlso isJetOk() Then
            currWeapon += 1

            If currWeapon > 2 Then currWeapon = 0

            If currWeapon = 0 Then
                msg("Rocket", 1000)
            ElseIf currWeapon = 1 Then
                msg("Cannon", 1000)
            ElseIf currWeapon = 2 Then
                msg("Bomb", 1000)
            End If
        End If

        If ((e.Key = hkShootRocket) OrElse ((currWeapon = 0) AndAlso (e.Key = Keys.LButton))) AndAlso isInJet() AndAlso isJetOk() Then
            For Each r As MR In myActualJet.MRL
                If r.enabled AndAlso Not r.isBomb AndAlso Not r.launched Then
                    If r.launch(planeDir() * 2.5, Exists(TJetLocked)) Then
                        timeWaitSoundRocket = 150

                        If camMode <> 4 Then sndRocket.Play() Else sndRocket2.Play()

                        Native.Function.Call("stop_sound", IDsndRocketMove)
                        Native.Function.Call("PLAY_SOUND_FROM_object", IDsndRocketMove, myActualJet.soundRocketMove, r.rocket)
                        timeWaitSoundRocket = 150
                        r.timeOut = 3000
                        r.TRocketsJetLocked = TJetLocked
                        r.THeliLocked = heliLocked
                        Native.Function.Call("stop_ptfx", r.ptfxExpID)

                        Exit Sub
                    End If
                End If
            Next
        End If

        If (groundZ > 8) AndAlso ((e.Key = hkDropBomb) OrElse ((currWeapon = 2) AndAlso (e.Key = Keys.LButton))) AndAlso isInJet() AndAlso isJetOk() Then
            For Each r As MR In myActualJet.MRL
                If r.enabled AndAlso r.isBomb AndAlso Not r.launched Then
                    r.launch((planeDir() / 1.5) * myJetSpeedAux() + Vector3.WorldDown * 50, False)

                    r.timeOut = 3000

                    Native.Function.Call("stop_sound", IDSndBombRelease)
                    Native.Function.Call("PLAY_SOUND_FROM_vehicle", IDSndBombRelease, myActualJet.soundBombRelease, myJet)

                    Exit Sub
                End If
            Next
        End If

        'if exists(camGun) andalso camGun.isactive then 
        '	camGun.deactivate
        '	camMode = 0
        'end if

        Dim bEjected As Boolean = False

        If Player.Character.isAlive Then
            If (e.Key = hkEject) AndAlso isInJet() AndAlso (myJet.Speed > 5) Then
                bEjected = True

                TJetLocked = Nothing

                If Exists(camGun) Then camGun.Deactivate()
                camMode = 0
                Player.Character.Visible = True

                If ptfxEject <> 0 Then Native.Function.Call("stop_ptfx", ptfxEject)

                ptfxEject = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "shot_directed_steam", _
                    myJet, 0, 2.5, 0, 0, 0, 0, 1.5)

                If myActualJet.cockpit_id > -1 Then Native.Function.Call("break_car_door", myJet, myActualJet.cockpit_id, False)

                sndEject.Play()

                Dim tmpVecPos As Vector3 = myJet.GetOffsetPosition(Vector3.WorldUp * myActualJet.jetModel.GetDimensions.Z)

                Player.Character.Invincible = True
                'player.character.task.clearallimmediately		
                'player.character.detach
                Native.Function.Call("ON_FIRE_SCREAM", Player.Character)
                Native.Function.Call("WARP_CHAR_FROM_CAR_TO_COORD", Player.Character, tmpVecPos.X, tmpVecPos.Y, tmpVecPos.Z)
                bWaterImpact = True
                'wait(250)
                'player.character.isragdoll = true			
                Player.Character.Velocity = planeDirUp() * 15 + planeDir() * (myJet.Speed)
                Player.Character.Health -= (myJet.Speed / 8)

                For Each j As TJet In jetList
                    'j.checkPAux.visible = False

                    If Not j.isMP AndAlso Exists(j.jet) AndAlso Exists(j.p) Then
                        j.p.Task.DriveTo((j.jet.Position + j.jet.Direction * 1000).Around(100), 80.0, False) ' fly away
                    End If
                Next

                timeResetPlayerInv = 250

                clearHeliList()
				
				Player.IgnoredByEveryone = False
            End If

            If Not bEjected AndAlso (e.Key = hkEnterJet) Then
                If isInJet() Then
                    TJetLocked = Nothing

                    If Exists(camGun) Then camGun.Deactivate()
                    camMode = 0
                    Player.Character.Visible = True

                    If (myJet.Speed < 2) Then
                        Dim vecPos As Vector3 = (myJet.Position + myJet.Direction * ((myJet.Model.GetDimensions.Y / 2) + 2)).ToGround

                        If myActualJet.cockpit_id <> -1 Then
                            If Exists(myFakeJet) AndAlso myActualJet.use_fake_jet Then Native.Function.Call("CONTROL_CAR_DOOR", myFakeJet, myActualJet.cockpit_id, True, 40 * (3.14 / 180))

                            Native.Function.Call("CONTROL_CAR_DOOR", myJet, myActualJet.cockpit_id, True, 40 * (3.14 / 180))

                            Wait(1000)
                        End If

                        Game.FadeScreenOut(250, True)
                        Wait(500)

                        Try
                            Player.Character.Task.ClearAll()
                            Native.Function.Call("WARP_CHAR_FROM_CAR_TO_COORD", Player.Character, vecPos.X, vecPos.Y, vecPos.Z)
                        Catch
                            msg("Error trying to exit the jet...", 5000)
                        End Try

                        Game.FadeScreenIn(250, False)

                        If myActualJet.cockpit_id <> -1 Then
                            Wait(300)
                            If Exists(myFakeJet) AndAlso myActualJet.use_fake_jet Then Native.Function.Call("CONTROL_CAR_DOOR", myFakeJet, myActualJet.cockpit_id, True, 0)

                            Native.Function.Call("CONTROL_CAR_DOOR", myJet, myActualJet.cockpit_id, True, 0)
                        End If
						
                        If bMustStop Then Native.Function.Call("SET_CAR_FORWARD_SPEED", myJet, 0)
                    End If

                    For Each j As TJet In jetList
                        'j.checkPAux.visible = False

                        If Not j.isMP AndAlso Exists(j.jet) AndAlso Exists(j.p) Then
                            j.p.Task.DriveTo((j.jet.Position + j.jet.Direction * 1000).Around(100), 80.0, False) ' fly away
                        End If
                    Next

                    clearHeliList()

                    Player.IgnoredByEveryone = False
                Else
                    Dim tmpVeh As Vehicle = Nothing

                    For Each j As TCustomJetCFG In TCustomJetCFGList
                        If Exists(Player.Character.CurrentVehicle) AndAlso (Player.Character.CurrentVehicle.Model = j.jetModel) Then tmpVeh = Player.Character.CurrentVehicle

                        If Not Exists(tmpVeh) Then tmpVeh = World.GetClosestVehicle(Player.Character.Position + Player.Character.Direction, 7.0, j.jetModel)

                        If Exists(tmpVeh) Then
                            myActualJet = j
                            Exit For
                        End If
                    Next

                    If Exists(tmpVeh) Then
                        If Exists(camGun) Then camGun.Deactivate()
                        camMode = 0
                        Player.Character.Visible = True

                        Player.Character.Task.ClearAllImmediately()
                        Player.Character.Task.GoTo(tmpVeh.Position + tmpVeh.Direction)

                        If (myActualJet.cockpit_id <> -1) Then
                            If Exists(myFakeJet) AndAlso myActualJet.use_fake_jet Then Native.Function.Call("CONTROL_CAR_DOOR", myFakeJet, myActualJet.cockpit_id, True, 40 * (3.14 / 180))

                            Native.Function.Call("CONTROL_CAR_DOOR", tmpVeh, myActualJet.cockpit_id, True, 40 * (3.14 / 180))

                            Wait(1000)
                        End If

                        Game.FadeScreenOut(250, True)
                        Wait(500)

                        Try
                            Player.Model = myActualJet.pilot_model
                            Player.Character.Task.WarpIntoVehicle(tmpVeh, VehicleSeat.Driver)
                        Catch
                            msg("Error trying to enter the jet...", 5000)
                        End Try

                        Game.FadeScreenIn(250, False)

                        If myActualJet.cockpit_id <> -1 Then
                            Wait(300)
                            If Exists(myFakeJet) AndAlso myActualJet.use_fake_jet Then Native.Function.Call("CONTROL_CAR_DOOR", myFakeJet, myActualJet.cockpit_id, True, 0)

                            Native.Function.Call("CONTROL_CAR_DOOR", tmpVeh, myActualJet.cockpit_id, True, 0)
                        End If
                    End If
                End If
            End If
        End If
    End Sub
    Private Sub keyUp(ByVal sender As Object, ByVal e As GTA.KeyEventArgs) Handles MyBase.KeyUp
        If bSetupHelpMode Then
            If (e.Key = Keys.up) OrElse (e.Key = Keys.down) OrElse (e.Key = Keys.left) OrElse (e.Key = Keys.right) _
                OrElse (e.Key = Keys.NumPad6) OrElse (e.Key = Keys.NumPad4) OrElse (e.Key = Keys.NumPad8) OrElse (e.Key = Keys.NumPad2) OrElse (e.Key = Keys.Subtract) OrElse (e.Key = Keys.Add) Then
                For Each m As MR In myActualJet.MRL
                    m.rocket.Visible = False
                    Native.Function.Call("stop_ptfx", m.ptfxID)

                    If myActualJet.MRL.IndexOf(m) = SM_actual_rocket Then
                        m.attach(myJet)
                        m.ptfxID = native.function.call(Of int32)("START_PTFX_ON_OBJ", "weap_rocket_player", m.rocket, 0, 0, 0, 0, 0, 0, 2.0)
                        m.rocket.Visible = True
                    End If
                Next
            End If

            Exit Sub
        End If

        If isInJet() AndAlso (e.Key = hkFlare) AndAlso (timeOutMyFlare <= 0) Then
            If timeHKFlareDown < 100 Then
                Native.Function.Call("stop_sound", IDSndBombRelease)
                Native.Function.Call("PLAY_SOUND_FROM_vehicle", IDSndBombRelease, myActualJet.soundBombRelease, myJet)

                timeOutMyFlare = 3000
                timeWaitResetFlarePTFX = 200

                Dim off As Int16 = -5

                For Each f As Flare In myFlares
                    f.flareObj.Detach()
                    f.flareObj.ApplyForce(rotateVec(planeDir, off) * myJet.Speed * 2 + Vector3.WorldDown * 30)
                    f.PTFXFlare = Native.Function.Call(Of Int32)("START_PTFX_ON_OBJ", "weap_rocket_player", f.flareObj, 0, 0, 0, 0, 0, 0, 0.5)

                    off += 5
                Next

                myFlareReleased = True
            End If
        End If

        If (e.Key = Keys.RButton) AndAlso bRocketCamON AndAlso camGun.isActive Then
            bRocketCamON = False

            camGun.Deactivate()
        End If

        If e.Key = hkSpawnMenu Then
            If TCustomJetCFGList.Count = 0 Then
                msg("There is no jets installed...", 6000)
                bSpawnMenuON = False
            Else
                bSpawnMenuON = Not bSpawnMenuON
            End If
        End If

        If bSpawnMenuON Then
            If (e.Key = Keys.Enter) Then
                For c As Int16 = 0 To TCustomJetCFGList.Count - 1
                    If c = SM_Current_index Then
                        bSpawnMenuON = False
                        spawnMyJet(TCustomJetCFGList(c))
                        Exit Sub
                    End If
                Next

                msg("Error detecting the jet :(", 6000)
            ElseIf (e.Key = hkNextMenuItem) OrElse (e.Key = hkPrevMenuItem) Then
                If e.Key = hkNextMenuItem Then SM_Current_index += 1
                If e.Key = hkPrevMenuItem Then SM_Current_index -= 1

                If SM_Current_index < 0 Then SM_Current_index = TCustomJetCFGList.Count - 1
                If SM_Current_index > TCustomJetCFGList.Count - 1 Then SM_Current_index = 0
            End If
        End If
    End Sub

    Private Sub spawnMyJet(ByVal j As TCustomJetCFG)
        Dim vecPos As vector3
        Dim bShiftDown As Boolean = game.iskeypressed(keys.shiftkey)

        camMode = 0
        If camGun.isActive Then camGun.Deactivate()

        msg("Creating jet: " & j.display_name, 3000)

        game.fadescreenout(500, True)

        Try
            player.model = j.pilot_model

            If bShiftDown Then
                vecPos = player.character.position + vector3.worldup * 50
            Else
                vecPos = player.character.position + game.currentcamera.direction * 15
                vecPos.z = player.character.position.z + 0.5
            End If

            Dim car As vehicle = world.createvehicle(j.jetModel, vecPos)

            wait(50)

            If Not exists(car) Then car = world.createvehicle(j.jetModel, vecPos)

            If Not exists(car) Then
                game.fadescreenin(250, False)
                wait(300)
                msg("error creating jet", 2000)
                Exit Sub
            End If

            car.heading = player.character.heading

            player.character.WarpIntoVehicle(car, vehicleseat.driver)

            If bShiftDown Then
                car.speed = 100
            End If
        Catch
        End Try

        game.fadescreenin(250, False)
    End Sub

    Private Sub setupModeKeypress(ByVal e As gta.KeyEventArgs)
        If (e.Key = Keys.C) Then
            If Not camDeath.isActive Then
                camDeath.Position = Game.CurrentCamera.Position
                camDeath.Direction = Game.CurrentCamera.Direction
                camDeath.FOV = Game.CurrentCamera.FOV
                camDeath.Activate()
            Else
                camDeath.Deactivate()
            End If
        End If

        If e.Key = Keys.B Then myActualJet.MRL(SM_actual_rocket).isBomb = Not myActualJet.MRL(SM_actual_rocket).isBomb

        If e.Key = Keys.Down Then
            SM_type += 1

            SM_actual_rocket = 0
            SM_actual_cannon = 0
            SM_actual_engine = 0
        End If

        If SM_type < 0 Then SM_type = 2
        If SM_type > 2 Then SM_type = 0

        If e.Key = Keys.Left Then
            If SM_type = 0 Then SM_actual_rocket -= 1
            If SM_type = 1 Then SM_actual_cannon -= 1
            If SM_type = 2 Then SM_actual_engine -= 1
        End If
        If e.Key = Keys.Right Then
            If SM_type = 0 Then SM_actual_rocket += 1
            If SM_type = 1 Then SM_actual_cannon += 1
            If SM_type = 2 Then SM_actual_engine += 1
        End If

        checkSM_Index

        If e.Key = Keys.G Then
            Dim nextPosAux As Int16 = 0

            If SM_type = 0 Then
                If SM_actual_rocket = myActualJet.MRL.Count - 1 Then nextPosAux = 0 Else nextPosAux = SM_actual_rocket + 1

                myActualJet.MRL(nextPosAux).xAttach = myActualJet.MRL(SM_actual_rocket).xAttach * -1
                myActualJet.MRL(nextPosAux).yAttach = myActualJet.MRL(SM_actual_rocket).yAttach
                myActualJet.MRL(nextPosAux).zAttach = myActualJet.MRL(SM_actual_rocket).zAttach
                myActualJet.MRL(nextPosAux).enabled = True

                SM_actual_rocket += 1

                msg("Oposite rocket generated!", 2000)
            ElseIf SM_type = 1 Then
                If SM_actual_cannon = myActualJet.cannList.Count - 1 Then nextPosAux = 0 Else nextPosAux = SM_actual_cannon + 1

                myActualJet.cannList(nextPosAux).offPosition.X = myActualJet.cannList(SM_actual_cannon).offPosition.X * -1
                myActualJet.cannList(nextPosAux).offPosition.Y = myActualJet.cannList(SM_actual_cannon).offPosition.Y
                myActualJet.cannList(nextPosAux).offPosition.Z = myActualJet.cannList(SM_actual_cannon).offPosition.Z
                myActualJet.cannList(nextPosAux).enabled = True

                SM_actual_cannon += 1

                msg("Oposite cannon generated!", 2000)
            ElseIf SM_type = 2 Then
                If SM_actual_engine = myActualJet.engineList.Count - 1 Then nextPosAux = 0 Else nextPosAux = SM_actual_engine + 1

                myActualJet.engineList(nextPosAux).offPosition.X = myActualJet.engineList(SM_actual_engine).offPosition.X * -1
                myActualJet.engineList(nextPosAux).offPosition.Y = myActualJet.engineList(SM_actual_engine).offPosition.Y
                myActualJet.engineList(nextPosAux).offPosition.Z = myActualJet.engineList(SM_actual_engine).offPosition.Z
                myActualJet.engineList(nextPosAux).enabled = True

                SM_actual_engine += 1

                msg("Oposite engine generated!", 2000)
            End If

            Wait(500)

            checkSM_Index()
        End If

        If e.Key = Keys.Enter Then
            If SM_type = 0 Then
                myActualJet.MRL(SM_actual_rocket).enabled = Not myActualJet.MRL(SM_actual_rocket).enabled
            ElseIf SM_type = 1 Then
                myActualJet.cannList(SM_actual_cannon).enabled = Not myActualJet.cannList(SM_actual_cannon).enabled
            ElseIf SM_type = 2 Then
                myActualJet.engineList(SM_actual_engine).enabled = Not myActualJet.engineList(SM_actual_engine).enabled
            End If
        End If

        If e.Key = Keys.NumPad0 Then saveNewSetup()
    End Sub

    Private Sub checkSM_Index()
        If SM_actual_rocket > myActualJet.MRL.Count - 1 Then SM_actual_rocket = 0
        If SM_actual_cannon > myActualJet.cannList.Count - 1 Then SM_actual_cannon = 0
        If SM_actual_engine > myActualJet.engineList.Count - 1 Then SM_actual_engine = 0

        If SM_actual_rocket < 0 Then SM_actual_rocket = myActualJet.MRL.Count - 1
        If SM_actual_cannon < 0 Then SM_actual_cannon = myActualJet.cannList.Count - 1
        If SM_actual_engine < 0 Then SM_actual_engine = myActualJet.engineList.Count - 1
    End Sub

    Private Function returnJetOffPos(ByVal j As TJet)
        Return j.jet.GetOffsetPosition(Vector3.RelativeRight * ((jetList.IndexOf(j) - Math.Round(jetList.Count / 2)) * 25)) - j.jet.Position
    End Function

    Private Sub releaseEnemyFlare(ByVal j As TJet)
        If Not j.flareReleased AndAlso (j.timeOutFlare <= 0) Then
            j.timeOutFlare = 5000

            'native.function.call("stop_ptfx", j.ptfxFlare)			
            'j.flareObj.detach			
            'j.flareObj.applyforce(enemyDir(j) * j.jet.speed + vector3.worlddown * 30)			
            'j.ptfxFlare = native.function.call(of int32)("START_PTFX_ON_OBJ", "weap_rocket_player", j.flareObj, 0, 0, 0, 0, 0, 0, 1.5)
            Dim off As Int16 = -5

            For Each f As Flare In enemyFlares
                Native.Function.Call("stop_ptfx", f.PTFXFlare)
                f.flareObj.Detach()
                f.flareObj.ApplyForce(rotateVec(enemyDir(j), off) * j.jet.Speed * 2 + Vector3.WorldDown * 30)
                f.PTFXFlare = Native.Function.Call(Of Int32)("START_PTFX_ON_OBJ", "weap_rocket_player", f.flareObj, 0, 0, 0, 0, 0, 0, 1.5)

                off += 5
            Next

            j.flareReleased = True
        End If
    End Sub

    Private Sub resetEnemyFlare(ByVal j As TJet)
        If enemyFlares.Count = 0 Then
            For c As Int16 = 1 To 5
                tmpFlare = New Flare
                enemyFlares.Add(tmpFlare)
            Next
        End If

        For Each f As Flare In enemyFlares
            If Not Exists(f.flareObj) Then
                f.flareObj = World.CreateObject("cj_proc_brick", Player.Character.Position.Around(5) + Vector3.WorldUp * 50)
                'f.flareObj.attachblip
                j.flareReleased = True
            End If

            Native.Function.Call("stop_ptfx", f.PTFXFlare)
            f.flareObj.AttachToVehicle(j.jet, Vector3.WorldDown, Vector3.Zero)
            f.flareObj.Visible = False
        Next

        j.flareReleased = False
    End Sub

    Private Function spawnEnemyJet(ByVal key As Keys, Optional ByVal bAutoSpawn As Boolean = False)
        'if wreckedJetList.count = 0 then
            Dim tmoCustomJet As TCustomJetCFG = Nothing

            tmpJet = New TJet
            tmpJet.is_hunter = (key = hkSpawnEnemy)
            tmpJet.is_fugitive = (key = hkSpawnFugitive)
            tmpJet.bAutoSpawn = bAutoSpawn

            If TCustomJetCFGList.Count > 0 Then
                Dim tmpIndex As Int16 = Math.Round(random(-2, TCustomJetCFGList.Count + 2))

                If tmpIndex < 0 Then
                    tmpIndex = 0
                ElseIf tmpIndex > TCustomJetCFGList.Count - 1 Then
                    tmpIndex = TCustomJetCFGList.Count - 1
                End If

                tmoCustomJet = TCustomJetCFGList(tmpIndex)

                tmpJet.jet = World.CreateVehicle(tmoCustomJet.jetModel, Player.Character.Position + Vector3.WorldUp * (200 - groundZ))

                tmpJet.back_gear_l = tmoCustomJet.back_gears_l_id
                tmpJet.back_gear_r = tmoCustomJet.back_gears_r_id
                tmpJet.front_gear_l = tmoCustomJet.front_gears_l_id
                tmpJet.front_gear_r = tmoCustomJet.front_gears_r_id
                tmpJet.flaps_r = tmoCustomJet.right_flap_id
                tmpJet.flaps_l = tmoCustomJet.left_flap_id
                tmpJet.flap_idle_angle = tmoCustomJet.idleFlapsAngle
                tmpJet.gears_closed_angle = tmoCustomJet.gears_closed_angle
            Else
                If TCustomJetCFGList.Count = 0 Then
                    msg("No enemy model was specified in the main INI file", 10000)
                    Return False
                End If

                tmoCustomJet = TCustomJetCFGList(0)

                tmpJet.jet = World.CreateVehicle(tmoCustomJet.jetModel, Player.Character.Position + Vector3.WorldUp * (200 - groundZ))

                tmpJet.back_gear_l = -1
                tmpJet.back_gear_r = -1
                tmpJet.front_gear_l = -1
                tmpJet.front_gear_r = -1
                tmpJet.flaps_r = -1
                tmpJet.flaps_l = -1
                tmpJet.flap_idle_angle = -1
                tmpJet.gears_closed_angle = -100
            End If

            If Exists(tmpJet.jet) Then
                tmpJet.jet.Visible = False
                'tmpJet.p = tmpJet.jet.CreatePedOnSeat(vehicleseat.driver, "m_y_cop_traffic", RelationshipGroup.cop)
                'tmpJet.p = world.createped("m_y_cop_traffic", player.character.position + vector3.worldup * 20)
                If myActualJet.sEnemy_model <> "" Then
                    tmpJet.p = World.CreatePed(myActualJet.enemy_model, Player.Character.Position + Vector3.WorldUp * 20)
                Else
                    tmpJet.p = World.CreatePed("m_m_fbi", Player.Character.Position + Vector3.WorldUp * 20)
                End If

                If Exists(tmpJet.p) Then
                    'tmpJet.dirObj = world.createobject("cj_rpg_rocket", tmpJet.jet.position.around(5) + vector3.worldup * 100)
                    'tmpJet.dirObjCenter = world.createobject("cj_rpg_rocket", tmpJet.jet.position.around(5) + vector3.worldup * 100)

                    'if exists(tmpJet.dirObj) andalso exists(tmpJet.dirObjCenter) then
                        tmpJet.p.CancelAmbientSpeech()
                        tmpJet.p.Task.ClearAll()
                        tmpJet.p.Task.WarpIntoVehicle(tmpJet.jet, VehicleSeat.Driver)

                        'native.function.call("ATTACH_OBJECT_TO_CAR", tmpJet.dirObj, tmpJet.jet, 0, 0, 1.0, 0, 0, 0, 0)
                        'native.function.call("ATTACH_OBJECT_TO_CAR", tmpJet.dirObjCenter, tmpJet.jet, 0, 0, 0, 0, 0, 0, 0)

                        tmpRocket = New MR
                        tmpRocket.rocket = World.CreateObject("cj_rpg_rocket", Player.Character.Position.Around(5) + Vector3.WorldUp * 100)
                        tmpRocket.Hide(tmpRocket.rocket)
                        tmpRocket.xAttach = -2.5
                        tmpRocket.yAttach = -3.0
                        tmpRocket.zAttach = -0.3
                        tmpRocket.attach(tmpJet.jet)
                        tmpJet.rockets.Add(tmpRocket)

                        tmpRocket = New MR
                        tmpRocket.rocket = World.CreateObject("cj_rpg_rocket", Player.Character.Position.Around(5) + Vector3.WorldUp * 100)
                        tmpRocket.Hide(tmpRocket.rocket)
                        tmpRocket.xAttach = 2.5
                        tmpRocket.yAttach = -3.0
                        tmpRocket.zAttach = -0.3
                        tmpRocket.attach(tmpJet.jet)
                        tmpJet.rockets.Add(tmpRocket)

                        resetEnemyFlare(tmpJet)

                        For Each e As engine In tmoCustomJet.engineList
                            If Not e.enabled Then Continue For

                            tmpEngine = New engine
                            'tmpEngine.x = e.x
                            'tmpEngine.y = e.y
                            'tmpEngine.z = e.z
                            tmpEngine.offPosition.X = e.offPosition.X
                            tmpEngine.offPosition.Y = e.offPosition.Y
                            tmpEngine.offPosition.Z = e.offPosition.Z
                            'tmpEngine.attachPoint = world.createobject("cj_rpg_rocket", player.character.position.around(5) + vector3.worldup * 100)
                            'native.function.call("ATTACH_OBJECT_TO_CAR", tmpEngine.attachPoint, tmpJet.jet, 0, e.x, e.y, e.z, 0, 0, 0)
                            'tmpEngine.attachPoint.visible = false
                            tmpEngine.engLight.Intensity = 300
                            tmpEngine.engLight.Enabled = True
                            tmpEngine.engLight.Color = Color.Goldenrod
                            tmpJet.engines.Add(tmpEngine)
                        Next

                        tmpJet.jet.Position = (Player.Character.Position + Vector3.WorldUp * 50).Around(300)
                        tmpJet.jet.Speed = 50.0
                        tmpJet.jet.Visible = True
                        tmpJet.jet.Metadata.isAnJet = True
                        tmpJet.p.Metadata.IsJetPilot = True

                        jetList.Add(tmpJet)

                        'If tmpJet.is_hunter Then
                            'tmpJet.checkPAux.Color = Color.FromArgb(100, 255, 0, 0)
                        'Else
                            'tmpJet.checkPAux.Color = Color.FromArgb(100, 200, 200, 0)
                        'End If

                        'tmpJet.checkPAux.Visible = True
                        'tmpJet.checkPAux.Diameter = 10
                        tmpJet.start()

                        Return True
                    'end if
                End If
            End If

            Return False
        'else
        '	dim tmpPed as ped = nothing
        '	
        '	tmpPed = world.createped("m_y_cop_traffic", player.character.position + vector3.worldup * 20)
        '	
        '	if exists(tmpPed) then
        '		tmpPed.CancelAmbientSpeech
        '		wreckedJetList.item(0).p = tmpPed
        '		wreckedJetList.item(0).p.visible = false
        '		wreckedJetList.item(0).p.task.clearall
        '		
        '		wreckedJetList.item(0).jet.visible = false
        '		wreckedJetList.item(0).jet.position = player.character.position + vector3.worldup * 20
        '		
        '		wreckedJetList.item(0).jet.repair
        '		wreckedJetList.item(0).jet.health = 1000
        '		wreckedJetList.item(0).jet.enginehealth = 1000
        '		wreckedJetList.item(0).jet.petroltankhealth = 1000
        '		wreckedJetList.item(0).jet.EngineRunning = true					
        '		wreckedJetList.item(0).jet.speed = 50	
        '		wreckedJetList.item(0).p.task.clearallimmediately
        '		wreckedJetList.item(0).p.task.WarpIntoVehicle(wreckedJetList.item(0).jet, vehicleseat.driver)
        '		
        '		resetEnemyFlare(wreckedJetList.item(0))
        '
        '		wreckedJetList.item(0).jet.position = (player.character.position + vector3.worldup * 50).around(300)
        '		wreckedJetList.item(0).p.visible = true
        '		wreckedJetList.item(0).jet.speed = 50.0
        '		wreckedJetList.item(0).jet.visible = true
        '		
        '		for each r as MR in wreckedJetList.item(0).rockets
        '			if r.launched then r.attach(wreckedJetList.item(0).jet)
        '		next
        '		
        '		jetList.add(wreckedJetList.item(0))
        '		
        '		wreckedJetList.item(0).start
        '		
        '		wreckedJetList.removeat(0)
        '	end if
        'end if
    End Function

    Private Sub general_tick(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Tick
        Try
        If timeWaitLoadsettings > 0 Then
            timeWaitLoadsettings -= Me.Interval

            If timeWaitLoadsettings <= 0 Then loadSettingsAux()

            Exit Sub
        End If

        If bSetupHelpMode Then
            Dim moveMulti As Double = 1

            If Game.isKeyPressed(Keys.ControlKey) Then moveMulti = 10

            If Game.isKeyPressed(Keys.Subtract) Then ' move up
                If SM_type = 0 Then myActualJet.MRL(SM_actual_rocket).zAttach -= 0.01 * moveMulti
                If SM_type = 1 Then myActualJet.cannList(SM_actual_cannon).offPosition.Z -= 0.02 * moveMulti
                If SM_type = 2 Then myActualJet.engineList(SM_actual_engine).offPosition.Z -= 0.02 * moveMulti
            End If
            If Game.isKeyPressed(Keys.Add) Then ' move down
                If SM_type = 0 Then myActualJet.MRL(SM_actual_rocket).zAttach += 0.01 * moveMulti
                If SM_type = 1 Then myActualJet.cannList(SM_actual_cannon).offPosition.Z += 0.02 * moveMulti
                If SM_type = 2 Then myActualJet.engineList(SM_actual_engine).offPosition.Z += 0.02 * moveMulti
            End If
            If Game.isKeyPressed(Keys.NumPad2) Then ' move backward
                If SM_type = 0 Then myActualJet.MRL(SM_actual_rocket).yAttach -= 0.01 * moveMulti
                If SM_type = 1 Then myActualJet.cannList(SM_actual_cannon).offPosition.Y -= 0.02 * moveMulti
                If SM_type = 2 Then myActualJet.engineList(SM_actual_engine).offPosition.Y -= 0.02 * moveMulti
            End If
            If Game.isKeyPressed(Keys.NumPad8) Then ' move forward
                If SM_type = 0 Then myActualJet.MRL(SM_actual_rocket).yAttach += 0.01 * moveMulti
                If SM_type = 1 Then myActualJet.cannList(SM_actual_cannon).offPosition.Y += 0.02 * moveMulti
                If SM_type = 2 Then myActualJet.engineList(SM_actual_engine).offPosition.Y += 0.02 * moveMulti
            End If
            If Game.isKeyPressed(Keys.NumPad6) Then ' move left
                If SM_type = 0 Then myActualJet.MRL(SM_actual_rocket).xAttach -= 0.01 * moveMulti
                If SM_type = 1 Then myActualJet.cannList(SM_actual_cannon).offPosition.X -= 0.02 * moveMulti
                If SM_type = 2 Then myActualJet.engineList(SM_actual_engine).offPosition.X -= 0.02 * moveMulti
            End If
            If Game.isKeyPressed(Keys.NumPad4) Then ' move left
                If SM_type = 0 Then myActualJet.MRL(SM_actual_rocket).xAttach += 0.01 * moveMulti
                If SM_type = 1 Then myActualJet.cannList(SM_actual_cannon).offPosition.X += 0.02 * moveMulti
                If SM_type = 2 Then myActualJet.engineList(SM_actual_engine).offPosition.X += 0.02 * moveMulti
            End If

            If SM_TimeWaitPTFX <= 0 Then
                SM_TimeWaitPTFX = 20

                If SM_type = 1 Then
                    If myActualJet.cannList(SM_actual_cannon).enabled Then
                        Native.Function.Call("stop_ptfx", myActualJet.cannList(SM_actual_cannon).ptfx)
                        myActualJet.cannList(SM_actual_cannon).ptfx = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "muz_machine", _
                            myJet, myActualJet.cannList(SM_actual_cannon).offPosition.X, myActualJet.cannList(SM_actual_cannon).offPosition.Y, _
                            myActualJet.cannList(SM_actual_cannon).offPosition.Z, 0, 0, 90.0, 1.0)
                    End If
                ElseIf SM_type = 2 Then
                    If myActualJet.engineList(SM_actual_engine).enabled Then
                        Native.Function.Call("stop_ptfx", myActualJet.engineList(SM_actual_engine).ptfx)
                        myActualJet.engineList(SM_actual_engine).ptfx = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "muz_pistol_large", _
                            myJet, myActualJet.engineList(SM_actual_engine).offPosition.X, myActualJet.engineList(SM_actual_engine).offPosition.Y, _
                            myActualJet.engineList(SM_actual_engine).offPosition.Z, 0, 0, -90.0, 1.0)
                    End If
                End If
            Else
                SM_TimeWaitPTFX -= Me.Interval
            End If

            If camDeath.isActive AndAlso Exists(Game.DefaultCamera) Then
                Dim tmpVec As Vector3 = camDeath.Position
                Dim tmpZ As Double = tmpVec.Z

                SM_Obj_aux.Position = camDeath.Position
                SM_Obj_aux.Rotation = camDeath.Rotation

                If Game.isGameKeyPressed(GameKey.MoveForward) Then
                    tmpVec += camDeath.Direction / 2
                ElseIf Game.isGameKeyPressed(GameKey.MoveBackward) Then
                    tmpVec -= camDeath.Direction / 2
                ElseIf Game.isGameKeyPressed(GameKey.MoveLeft) Then
                    tmpVec = SM_Obj_aux.GetOffsetPosition(Vector3.RelativeLeft / 4)
                ElseIf Game.isGameKeyPressed(GameKey.MoveRight) Then
                    tmpVec = SM_Obj_aux.GetOffsetPosition(Vector3.RelativeRight / 4)
                End If

                camDeath.Position = tmpVec

                tmpVec = rotateVec(camDeath.Direction, (Game.Mouse.Movement.X * 5) * -20)
                tmpVec.Z -= Game.Mouse.Movement.Y * 2
                camDeath.Direction = tmpVec
            End If

            Exit Sub
        End If

        If bShowPosition Then
            Dim charPos As Vector3 = Player.Character.Position
            charPos.Z = Player.Character.Position.ToGround.Z

            msg("Position: " & charPos.ToString & "    heading: " & Player.Character.Heading, 100)
        End If

        If Game.isKeyPressed(hkFlare) Then
            If (timeHKFlareDown < 100) Then timeHKFlareDown += Me.Interval
        Else
            timeHKFlareDown = 0
        End If

		
		If timeCheckHeli <= 0 Then
			timeCheckHeli = 500

			checkHeli()
		Else
			timeCheckHeli -= Me.Interval
		End If
		
        If timeResetPlayerInv > 0 Then
            timeResetPlayerInv -= Me.Interval

            If timeResetPlayerInv <= 0 Then Player.Character.Invincible = False
        End If

        If (Not Player.Character.isAlive) AndAlso bPlayerWasAlive Then
            bPlayerWasAlive = False

            bResetPL = True
        End If

        bPlayerWasAlive = Player.Character.isAlive

        checkSpaceTrip()

        If timeSearchIdleJets <= 0 Then
            timeSearchIdleJets = 1000

            searchForOtherJets()
        Else
            timeSearchIdleJets -= Me.Interval
        End If

        If bWaterImpact AndAlso Player.Character.isAlive AndAlso Player.Character.isInWater Then
            If Player.Character.Velocity.Z <= -31 Then
                Player.Character.Die()
            Else
                Player.Character.Health += (Player.Character.Velocity.Z * 2)

                Player.Character.ForceRagdoll(6000, False)
            End If

            bWaterImpact = False
        End If

        ' jet aquirement tick
        checkJetAP()

        ' flare tick
        If timeOutMyFlare > 0 Then timeOutMyFlare -= Me.Interval

        If myFlareReleased AndAlso (Not Exists(myJet) OrElse (myFlares(0).flareObj.Position.DistanceTo(myJet.Position) > 400)) Then
            'native.function.call("stop_ptfx", PTFXMyFlare)
            For Each f As Flare In myFlares
                Native.Function.Call("stop_ptfx", f.PTFXFlare)

                myFlaresResetList.Add(f)
            Next

            myFlareReleased = False
        End If

        Try
            If myFlaresResetList.Count > 0 Then
                If timeWaitResetFlarePTFX > 0 Then
                    timeWaitResetFlarePTFX -= Me.Interval
                Else
                    For Each f As Flare In myFlaresResetList
                        f.flareObj.AttachToVehicle(myJet, Vector3.WorldDown, Vector3.Zero)
                    Next

                    myFlaresResetList.Clear()
                End If
            End If
        Catch
        End Try

        If bResetPL AndAlso (Player.Character.Health > 0) Then
            bResetPL = False

            Player.Character.Visible = True
            Player.Character.FreezePosition = False
            Game.TimeScale = 1.0
            Player.IgnoredByEveryone = False

            If Player.Model <> original_model Then
                Game.FadeScreenOut(200, True)

                Try
                    Wait(500)
                    Player.Model = original_model

                    Native.Function.Call("SET_CHAR_COMPONENT_VARIATION", Player.Character, 0, 0, 0)
                    Native.Function.Call("SET_CHAR_COMPONENT_VARIATION", Player.Character, 1, 0, 0)
                    Native.Function.Call("SET_CHAR_COMPONENT_VARIATION", Player.Character, 2, 0, 0)
                    Native.Function.Call("SET_CHAR_COMPONENT_VARIATION", Player.Character, 4, 0, 0)
                    Native.Function.Call("SET_CHAR_COMPONENT_VARIATION", Player.Character, 5, 0, 0)
                    Native.Function.Call("SET_CHAR_COMPONENT_VARIATION", Player.Character, 7, 0, 0)
                    Native.Function.Call("SET_CHAR_COMPONENT_VARIATION", Player.Character, 9, 0, 0)

                    camDeath.Deactivate()
                    camDeath.Position = Player.Character.Position
                    camDeath.Activate()
                    Wait(100)
                    camDeath.Deactivate()
                    Wait(200)
                Catch
                End Try

                Game.FadeScreenIn(500, True)
            End If

            bWaterImpact = False

            For c As Int16 = jetList.Count - 1 To 0 Step -1
                removeJet(c)
            Next

            timeLastAutoSpawnEnemies = 0

            For Each ap As TJetAP In TJetAPList
                ap.resetPosition = True

                If Exists(ap.createdJet) Then ap.createdJet.Delete()

                resetAPJet(ap)
            Next
        End If

        setJet()

        If timeLastAutoSpawnEnemies > 0 Then timeLastAutoSpawnEnemies -= Me.Interval

        If Exists(myJet) AndAlso Exists(myActualJet) Then
            'msg(myJet.health.tostring & "   " & myJet.enginehealth.tostring & "   " & myJet.petroltankhealth.tostring, 100)

            If timeShowFlareAux > 0 Then timeShowFlareAux -= Me.Interval

            If (timeHKFlareDown >= 100) AndAlso Game.isKeyPressed(hkFlare) Then
                For Each f As Flare In myFlares
                    If f.flareObj.isAttachedSomewhere Then
                        If (timeWaitNextRelFlare <= 0) Then
                            f.flareObj.Detach()
                            f.flareObj.ApplyForce(planeDir() * myJet.Speed * 2 + Vector3.WorldDown * 30)
                            f.PTFXFlare = Native.Function.Call(Of Int32)("START_PTFX_ON_OBJ", "weap_rocket_player", f.flareObj, 0, 0, 0, 0, 0, 0, 0.5)

                            myFlareReleased = True
                            timeOutMyFlare = 3000
                            timeWaitResetFlarePTFX = 200

                            timeWaitNextRelFlare = 20

                            Native.Function.Call("stop_sound", IDSndBombRelease)
                            Native.Function.Call("PLAY_SOUND_FROM_vehicle", IDSndBombRelease, myActualJet.soundBombRelease, myJet)
                        Else
                            timeWaitNextRelFlare -= Me.Interval
                        End If

                        Exit For
                    End If
                Next
            End If

            If timeWaitSoundRocket > 0 Then timeWaitSoundRocket -= Me.Interval

            If Exists(camGun) Then
                If camMode = 1 Then
                    camGun.Position = Player.Character.Position + planeDirUp() * myActualJet.cam1_up_offset + planeDir() * myActualJet.cam1_ahead_Offset
                    camGun.Direction = planeDir()
                    camGun.Rotation = myJet.Rotation
                ElseIf camMode = 2 Then
                    camGun.Position = Player.Character.Position - planeDirUp() * myActualJet.cam2_up_offset + planeDir() * myActualJet.cam2_ahead_Offset
                    camGun.Direction = planeDir()
                    camGun.Rotation = myJet.Rotation
                ElseIf camMode = 3 Then
                    camGun.Position = Player.Character.Position - planeDir() * myActualJet.cam3_ahead_Offset + planeDirUp() * myActualJet.cam3_up_offset
                    camGun.Direction = planeDir()
                    camGun.Rotation = myJet.Rotation
                ElseIf camMode = 4 Then
                    camGun.Position = myJet.GetOffsetPosition(camPilotOffset)
                    Player.Character.Visible = Not camPilotHidePlayer

                    If bFixedCockpitCam AndAlso ((Math.Abs(Game.Mouse.Movement.X) > 0.01) OrElse (Math.Abs(Game.Mouse.Movement.Y) > 0.01)) Then bFixedCockpitCam = False

                    If camPilotFixedRotation OrElse bFixedCockpitCam Then
                        camGun.Rotation = myJet.Rotation
                    Else
                        Dim tmpRot As Vector3 = camGun.Rotation
                        tmpRot.Y = myJet.Rotation.Y

                        camGun.Rotation = tmpRot

                        If Exists(Game.DefaultCamera.Direction) Then camGun.Direction = Game.DefaultCamera.Direction
                    End If
                ElseIf camMode = 5 Then
                    camGun.Position = myJet.Position + planeDir() * (myJet.Model.GetDimensions.Y / 1.8)

                    camGun.Rotation = myJet.Rotation
                End If

                If (camMode > 0) AndAlso Not camGun.isActive Then camGun.Activate()
            End If

            Try
                For c As Int16 = myActualJet.MRLReset.Count - 1 To 0 Step -1
                    If myActualJet.MRLReset(c).timeResetPTFX > 0 Then
                        myActualJet.MRLReset(c).timeResetPTFX -= Me.Interval
                    Else
                        myActualJet.MRLReset(c).attach(myJet)
                        myActualJet.MRLReset.RemoveAt(c)
                    End If
                Next
            Catch
            End Try

            For Each r As MR In myActualJet.MRL
                If Not r.enabled Then Continue For

                If Exists(r.rocket) AndAlso r.launched AndAlso Not r.bReseting Then
                    If r.propulsor_effect_size > 0 Then
                        'if r.timeResetPTFX <= 0 then
                        '	r.timeResetPTFX = 20
                        '	native.function.call("stop_ptfx", r.ptfxID)							
                        '	r.ptfxID = native.function.call(of int32)("START_PTFX_ON_OBJ", "weap_rocket_player", r.rocket, 0, 0, 0, 0, 0, 0, r.propulsor_effect_size)
                        'else
                        '	r.timeResetPTFX -= me.interval
                        'end if
                    End If

                    If (r.rocket.Position.DistanceTo(myJet.Position) > 15) AndAlso _
                       (Native.Function.Call(Of Boolean)("HAS_OBJECT_COLLIDED_WITH_ANYTHING", r.rocket) OrElse (r.timeOut <= 0)) Then
                        Dim rocketPos As Vector3 = r.rocket.Position

                        r.ptfxExpID = Native.Function.Call(Of Int32)("start_PTFX", "exp_ship_destroy", rocketPos.X, rocketPos.Y, rocketPos.Z, 0, 0, 0, r.explosion_size)

                        If Not Exists(r.TRocketsJetLocked) Then
                            World.AddExplosion(rocketPos, ExplosionType.Rocket, 100.0, True, True, 1.0)

                            Dim bWanted As Boolean = False

                            For Each v As Vehicle In World.GetVehicles(rocketPos, 20.0 * r.explosion_force)
                                If Exists(v) AndAlso (Math.Abs(v.Position.Z - rocketPos.Z) < 3) AndAlso Not v.Metadata.isAnJet AndAlso Not v.Metadata.isAnHeli Then
                                    bWanted = True

                                    If Not v.Model.isTrain Then
                                        Native.Function.Call("detach_car", v)
                                        v.FreezePosition = False
                                        v.ApplyForce((((v.Position - rocketPos) + Vector3.WorldUp * 3) / (v.Position.DistanceTo(rocketPos) / 4)) * r.explosion_force, _
                                            Vector3.WorldUp * 4)

                                        If (v.Position.DistanceTo(rocketPos) <= 15 * r.explosion_force) Then v.PetrolTankHealth = -1
                                    Else
                                        trainItem = New trains(v)
                                        trainList.Add(trainItem)
                                        v.Delete()
                                    End If
                                End If
                            Next
                            For Each p As Ped In World.GetPeds(rocketPos, 25.0 * r.explosion_force)
                                If Exists(p) AndAlso Not p.Metadata.IsJetPilot Then
                                    bWanted = True
                                    p.PreventRagdoll = False
                                    p.Euphoria.BodyBalance.Start(5000)
                                    p.ApplyForce((((p.Position - rocketPos) + Vector3.WorldUp * 2) / (p.Position.DistanceTo(rocketPos) / 10)) * r.explosion_force, Vector3.WorldNorth)
                                End If
                            Next

                            Dim fakeTrain As GTA.Object = Nothing

                            For Each t As trains In trainList
                                If t.bCreate Then
                                    fakeTrain = World.CreateObject(t.m, t.pos)

                                    If Exists(fakeTrain) Then
                                        t.train = fakeTrain
                                        t.train.Rotation = t.rot
                                    End If
                                End If
                            Next

                            ' increase wanted level
                            If bWanted Then
                                'player.character.WantedByPolice = true
                                'native.function.call("ALTER_WANTED_LEVEL_NO_DROP", player, 6)
                                'native.function.call("APPLY_WANTED_LEVEL_CHANGE_NOW", player, 6)

                                If (timeLastAutoSpawnEnemies <= 0) Then
                                    For c As Int16 = 1 To 3
                                        If spawnEnemyJet(hkSpawnEnemy, True) Then
                                            Exit For
                                        Else
                                            Wait(50)
                                        End If
                                    Next

                                    timeLastAutoSpawnEnemies = 15000
                                End If
                            End If
                        Else
                            If Exists(r.TRocketsJetLocked.jet) AndAlso (r.rocket.Position.DistanceTo(r.TRocketsJetLocked.jet.Position) < 10) Then
                                If r.TRocketsJetLocked.jet.Health > 0 Then
                                    r.TRocketsJetLocked.jet.Health -= random(r.damage_against_jets - 100, r.damage_against_jets)
                                    'r.TRocketsJetLocked.jet.enginehealth -= random(r.damage_against_jets - 100, r.damage_against_jets)
                                    'r.TRocketsJetLocked.jet.petroltankhealth -= random(r.damage_against_jets - 100, r.damage_against_jets)

                                    r.TRocketsJetLocked.jet.EngineHealth = 1000
                                    r.TRocketsJetLocked.jet.PetrolTankHealth = 1000

                                    r.TRocketsJetLocked.DamagedByPlayer = True
                                Else
                                    explodeEnemyJet(r.TRocketsJetLocked)
                                End If
                            End If

                            timeLastAutoSpawnEnemies = 1000
                        End If

                        'r.attach(myJet)
                        r.timeResetPTFX = 200
                        Native.Function.Call("stop_ptfx", r.ptfxID)
                        r.bReseting = True
                        myActualJet.MRLReset.Add(r)

                        Native.Function.Call("stop_sound", IDsndRocketMove)
                    Else
                        If Not Exists(r.TRocketsJetLocked) Then
                            r.timeOut -= Me.Interval
                        Else
                            r.timeOut -= (Me.Interval / 3)
                        End If

                        If Not r.isBomb Then
                            Dim tmpDirection As Vector3

                            If Exists(r.TRocketsJetLocked) AndAlso Exists(r.TRocketsJetLocked.jet) Then
                                If (r.TRocketsJetLocked.jet.Health < 500) AndAlso (r.rocket.Position.DistanceTo(enemyFlares(0).flareObj.Position) < 150) Then _
                                    releaseEnemyFlare(r.TRocketsJetLocked)

                                Dim distTmp As Double = r.rocket.Position.DistanceTo(r.TRocketsJetLocked.jet.Position)
                                Dim flareDist As Double = -1

                                If r.TRocketsJetLocked.flareReleased Then
                                    flareDist = enemyFlares(0).flareObj.Position.DistanceTo(r.TRocketsJetLocked.jet.Position)
                                    If (flareDist > 400) Then
                                        If (r.rocket.Position.DistanceTo(enemyFlares(0).flareObj.Position) < 150) Then
                                            resetEnemyFlare(r.TRocketsJetLocked)

                                            For Each r2 As MR In myActualJet.MRL
                                                If Not r2.enabled Then Continue For

                                                If (r2.rocket.Position.DistanceTo(enemyFlares(0).flareObj.Position) < 150) Then r2.TRocketsJetLocked = Nothing
                                            Next

                                            Exit Sub
                                        Else
                                            resetEnemyFlare(r.TRocketsJetLocked)
                                        End If
                                    Else
                                        If enemyFlares(0).flareObj.Position.DistanceTo(r.rocket.Position) < 10 Then
                                            r.timeOut = 0

                                            'resetEnemyFlare(r.TRocketsJetLocked)
                                        End If
                                    End If
                                End If

                                If r.TRocketsJetLocked.flareReleased AndAlso (flareDist < 150) Then
                                    tmpDirection = (enemyFlares(Math.Round(enemyFlares.Count / 2)).flareObj.Position - r.rocket.Position) / (distTmp / 3)
                                Else
                                    tmpDirection = ((r.TRocketsJetLocked.jet.Position - r.rocket.Position) / (distTmp / 3))
                                End If

                                r.final_dir = r.dir + tmpDirection * (myJetSpeedAux() * 1.5) * r.speed_multiplier

                                Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, r.final_dir.X, r.final_dir.Y, r.final_dir.Z)

                                r.fixRotation = Helper.DirectionToRotation(Vector3.Normalize(r.final_dir), 0)

                                If r.rocket.Position.DistanceTo(r.TRocketsJetLocked.jet.Position) < 5 Then
                                    r.timeOut = 0
                                End If
                            Else
                                ' heli locked
                                If Exists(r.THeliLocked) Then
                                    tmpDirection = ((r.THeliLocked.Position - r.rocket.Position) / (r.rocket.Position.DistanceTo(r.THeliLocked.Position) / 1.8))

                                    r.final_dir = r.dir + tmpDirection * (myJetSpeedAux() * 1.5) * r.speed_multiplier

                                    Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, r.final_dir.X, r.final_dir.Y, r.final_dir.Z)

                                    If r.rocket.Position.DistanceTo(r.THeliLocked.Position) < 80 Then
                                        For Each p As Ped In World.GetPeds(r.THeliLocked.Position, 15.0)
                                            If Exists(p) AndAlso (p.CurrentVehicle = r.THeliLocked) AndAlso Not p.Metadata.isLeavingHeli Then
                                                p.Metadata.isLeavingHeli = True
                                                p.Task.LeaveVehicleImmediately(r.THeliLocked)
                                                Native.Function.Call("ON_FIRE_SCREAM", p)
                                            End If
                                        Next
                                    End If

                                    r.fixRotation = Helper.DirectionToRotation(Vector3.Normalize(r.final_dir), 0)
                                Else
                                    If r.final_dir <> Vector3.Zero Then
                                        Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, _
                                            r.final_dir.X, r.final_dir.Y, r.final_dir.Z)

                                        r.fixRotation = Helper.DirectionToRotation(Vector3.Normalize(r.final_dir), 0)
                                    Else
                                        If myJet.Speed > 60 Then
                                            Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, _
                                                r.dir.X * (myJet.Speed * 1.4) * r.speed_multiplier, _
                                                r.dir.Y * (myJet.Speed * 1.4) * r.speed_multiplier, _
                                                r.dir.Z * (myJet.Speed * 1.4) * r.speed_multiplier)
                                        Else
                                            Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, _
                                                r.dir.X * 50 * r.speed_multiplier, _
                                                r.dir.Y * 50 * r.speed_multiplier, _
                                                r.dir.Z * 50 * r.speed_multiplier)
                                        End If

                                        r.fixRotation = Helper.DirectionToRotation(Vector3.Normalize(r.dir), 0)
                                    End If
                                End If
                            End If
                        Else
                            Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, _
                                r.dir.X * r.speed_multiplier, _
                                r.dir.Y * r.speed_multiplier, _
                                r.dir.Z * r.speed_multiplier)

                            r.fixRotation = Helper.DirectionToRotation(r.dir, 0)
                        End If
                    End If

                    r.rocket.Rotation = r.fixRotation

                    If Native.Function.Call(Of Boolean)("IS_OBJECT_IN_WATER", r.rocket) Then r.timeOut = 0

                    If Exists(camGun) Then
                        If r.launched AndAlso Game.isGameKeyPressed(GameKey.Aim) Then
                            bRocketCamON = True

                            camGun.Position = r.rocket.Position
                            camGun.Rotation = r.rocket.Rotation

                            If Exists(r.TRocketsJetLocked) OrElse Exists(r.THeliLocked) Then
                                camGun.Direction = r.final_dir
                            Else
                                camGun.Direction = r.rocket.Direction
                            End If

                            If Not camGun.isActive Then camGun.Activate()
                        ElseIf (camMode = 0) AndAlso camGun.isActive Then
                            camGun.Deactivate()
                            Player.Character.Visible = True

                            bRocketCamON = False
                        End If
                    End If
                End If
            Next

            If Not bExplodeMyJet And Player.Character.Health > 0 Then bExplodeMyJet = True

            If Exists(myJet) AndAlso (myJet.Speed > 30) AndAlso Native.Function.Call(Of Boolean)("IS_CAR_IN_WATER", myJet) Then
                explodeMyJet()
            End If

            If (Player.Character.CurrentVehicle <> myJet) Then
                Dim vecGround As Vector3 = World.GetGroundPosition(myJet.Position, GroundType.Highest)

                If (vecGround.DistanceTo(myJet.Position) > 30) Then
                '	if not myJet.metadata.falling then 
                '		myJet.metadata.falling = true
                '		myJet.applyforce(vector3.worlddown, vector3.worldeast * 3)
                '	end if

                    If (actualJetSpeed > 40) Then actualJetSpeed -= 0.2

                    If actualJetSpeed > 80 Then
                        Native.Function.Call("SET_CAR_FORWARD_SPEED", myJet, actualJetSpeed)
                    Else
                        myJet.ApplyForce(Vector3.WorldDown / 2)
                    End If

                    If (myJet.Rotation.X > -5) Then
                        myJet.ApplyForce(Vector3.WorldDown / 10, Vector3.WorldNorth / 20)
                    End If
                End If

                If jetList.Count > 0 Then
                    For c As Int16 = jetList.Count - 1 To 0 Step -1
                        jetList(c).timeRemove = 0
                    Next
                End If
            Else
                ' flaps helper
                If bFlapsHelpMode Then
                    Dim tmpJet As Vehicle = myJet

                    If Exists(myFakeJet) AndAlso myActualJet.use_fake_jet Then tmpJet = myFakeJet

                    If Game.isKeyPressed(Keys.NumPad0) Then Native.Function.Call("open_car_door", tmpJet, 0) Else Native.Function.Call("shut_car_door", tmpJet, 0)
                    If Game.isKeyPressed(Keys.NumPad1) Then Native.Function.Call("open_car_door", tmpJet, 1) Else Native.Function.Call("shut_car_door", tmpJet, 1)
                    If Game.isKeyPressed(Keys.NumPad2) Then Native.Function.Call("open_car_door", tmpJet, 2) Else Native.Function.Call("shut_car_door", tmpJet, 2)
                    If Game.isKeyPressed(Keys.NumPad3) Then Native.Function.Call("open_car_door", tmpJet, 3) Else Native.Function.Call("shut_car_door", tmpJet, 3)
                    If Game.isKeyPressed(Keys.NumPad4) Then Native.Function.Call("open_car_door", tmpJet, 4) Else Native.Function.Call("shut_car_door", tmpJet, 4)
                    If Game.isKeyPressed(Keys.NumPad5) Then Native.Function.Call("open_car_door", tmpJet, 5) Else Native.Function.Call("shut_car_door", tmpJet, 5)
                End If

                If myJet.Speed > 40 Then
                    If Game.isKeyPressed(hkTurnLeft) OrElse Game.isKeyPressed(hkTurnRight) OrElse Game.isKeyPressed(hkRollLeft) OrElse Game.isKeyPressed(hkRollRight) _
                       OrElse Game.isKeyPressed(hkUp) OrElse Game.isKeyPressed(hkDown) Then
                        If moveForceMultAux < 1 Then
                            moveForceMultAux += 0.1
                        Else
                            moveForceMultAux = 1
                        End If
                    Else
                        moveForceMultAux = 0.1
                    End If

                    If Game.isKeyPressed(hkTurnLeft) Then myJet.ApplyForceRelative(Vector3.RelativeFront / 3, Vector3.WorldEast * myActualJet.moveLeftForce * moveForceMultAux)
                    If Game.isKeyPressed(hkTurnRight) Then myJet.ApplyForceRelative(Vector3.RelativeFront / 3, Vector3.WorldWest * myActualJet.moveRightForce * moveForceMultAux)
                    If Game.isKeyPressed(hkRollLeft) Then myJet.ApplyForceRelative(Vector3.WorldUp / 10, Vector3.WorldEast * 7 * myActualJet.rollLeftForce * moveForceMultAux)
                    If Game.isKeyPressed(hkRollRight) Then myJet.ApplyForceRelative(Vector3.WorldUp / 10, Vector3.WorldWest * 7 * myActualJet.rollRightForce * moveForceMultAux)
                    If Game.isKeyPressed(hkUp) Then myJet.ApplyForceRelative(Vector3.RelativeFront, Vector3.WorldDown * 2 * myActualJet.moveUpForce * moveForceMultAux)
                    If Game.isKeyPressed(hkDown) Then myJet.ApplyForceRelative(Vector3.RelativeFront, Vector3.WorldUp * 2 * myActualJet.moveDownForce * moveForceMultAux)
                ElseIf (myJet.Speed > 5) AndAlso (groundZ < 8) Then
                    If Game.isKeyPressed(hkTurnLeft) OrElse Game.isKeyPressed(hkTurnRight) OrElse Game.isKeyPressed(hkRollLeft) OrElse Game.isKeyPressed(hkRollRight) _
                       OrElse Game.isKeyPressed(hkUp) OrElse Game.isKeyPressed(hkDown) Then
                        If moveForceMultAux < 1 Then
                            moveForceMultAux += 0.1
                        Else
                            moveForceMultAux = 1
                        End If
                    Else
                        moveForceMultAux = 0.1
                    End If

                    If Game.isKeyPressed(hkTurnLeft) Then myJet.ApplyForceRelative(Vector3.RelativeFront / 10, Vector3.WorldEast * myActualJet.moveLeftForce * moveForceMultAux * 1.5)
                    If Game.isKeyPressed(hkTurnRight) Then myJet.ApplyForceRelative(Vector3.RelativeFront / 10, Vector3.WorldWest * myActualJet.moveRightForce * moveForceMultAux * 1.5)
                    If Game.isKeyPressed(hkDown) Then myJet.ApplyForceRelative(Vector3.RelativeFront / 10, Vector3.WorldUp * 2 * myActualJet.moveDownForce * moveForceMultAux)
					
					if Game.isKeyPressed(hkTurnLeft) orelse Game.isKeyPressed(hkTurnRight) then bMustStop = false
                End If

                ' max jet speed :)
                If Game.isGameKeyPressed(GameKey.MoveForward) AndAlso (groundZ < 700) Then
					bMustStop = false
					
                    If actualJetSpeed < 80 Then
                        If groundZ > 10 Then
                            actualJetSpeed += 0.1

                            actualJetSpeed += (actualJetSpeed / 200)

                            If Game.isKeyPressed(Keys.Space) Then actualJetSpeed += (actualJetSpeed / 50)
                        Else
                            actualJetSpeed = myJet.Speed
                        End If
                    ElseIf actualJetSpeed < myActualJet.maxJetSpeed Then
                        actualJetSpeed += ((myActualJet.maxJetSpeed + 100) / actualJetSpeed / 5)
                    End If
                ElseIf Game.isGameKeyPressed(GameKey.MoveBackward) Then
                    If actualJetSpeed > 60 Then actualJetSpeed -= 0.8
                Else
                    If actualJetSpeed > 80 Then actualJetSpeed -= 0.1
                End If

                If (actualJetSpeed > 80) Then
                    If (actualJetSpeed > (myActualJet.maxJetSpeed / 2)) AndAlso (Game.isKeyPressed(Keys.ShiftKey) OrElse Game.isKeyPressed(Keys.ControlKey)) Then _
                        actualJetSpeed -= (((myActualJet.maxJetSpeed + 100) / actualJetSpeed / 5) * 2)
                End If

                If groundZ > 12 Then
                    Native.Function.Call("SET_CAR_FORWARD_SPEED", myJet, actualJetSpeed)
                ElseIf Game.isGameKeyPressed(GameKey.MoveBackward) AndAlso (groundZ < 8) Then
                    myJet.ApplyForceRelative(Vector3.RelativeBack * (myJet.Speed * 0.01))
					
					actualJetSpeed = 0
					
					if myjet.speed < 2 then 
						
						bMustStop = true
					end if
                End If

				if bMustStop then Native.Function.Call("SET_CAR_FORWARD_SPEED", myJet, 0)
				
                'if (actualJetSpeed < 60) andalso not myJet.isOnAllWheels then myjet.applyforce(vector3.worlddown * 1)

                ' water effect :)
                If timeWaterEffect <= 0 Then
                    timeWaterEffect = 20

                    If (myJet.Speed > 40) AndAlso (Player.Character.Position.Z < 50) Then
                        Dim tmpGroundPos As Vector3 = World.GetGroundPosition(Player.Character.Position, GroundType.Highest)
                        ' this groundPos method will fail when you fly under bridges :(, because the game/scripthook detects the bridge as the ground and not the water
                        ' because of this behavior we need this timeKeepWaterEffect to help keep the effect while we pass under the bridges :)
                        If (timeKeepWaterEffect > 0) OrElse (tmpGroundPos.Z <= 0) Then
                            tmpGroundPos -= (planeDir() * (60 - (50 - myJet.Position.Z)))

                            tmpGroundPos = tmpGroundPos.ToGround

                            Native.Function.Call("stop_ptfx", PTFXWater)

                            If tmpGroundPos.Z > 5 Then tmpGroundPos.Z = 0

                            PTFXWater = Native.Function.Call(Of Int32)("start_ptfx", "water_fountain_castle_up", tmpGroundPos.X, tmpGroundPos.Y, tmpGroundPos.Z - 10, 0, 0, 0, _
                                ((50 - Player.Character.Position.Z) / 20))

                            If (tmpGroundPos.Z <= 0) Then
                                timeKeepWaterEffect = 500
                            Else
                                timeKeepWaterEffect -= Me.Interval
                            End If
                        End If
                    Else
                        If PTFXWater <> 0 Then
                            Native.Function.Call("stop_ptfx", PTFXWater)
                            PTFXWater = 0
                        End If
                    End If
                Else
                    timeWaterEffect -= Me.Interval
                End If

                groundZ = Math.Round(Player.Character.Position.Z, 0)

                JetLowHealthEffects()

                EnemyJetTick()

                ' reset other health values
                If myJet.Health > 0 Then
                    myJet.EngineHealth = 1000
                    myJet.PetrolTankHealth = 1000
                Else
                    explodeMyJet()
                End If

                ' some extra gravity force
                'if game.isgamekeypressed(gamekey.movebackward) then _
                '	myJet.applyforce(vector3.worlddown * ((80 - myJet.speed) * 0.005))

                ' move wings				
                If Not bFlapsHelpMode Then
                    Dim tmpJet As Vehicle = myJet

                    If Exists(myFakeJet) AndAlso myActualJet.use_fake_jet Then tmpJet = myFakeJet

                    If (myActualJet.maxWingAngle > 0) AndAlso (myActualJet.left_wing_id > -1) AndAlso (myActualJet.right_wing_id > -1) Then
                        If Game.isGameKeyPressed(GameKey.MoveForward) AndAlso (myJet.Speed > 60) Then
                            If myActualJet.wingsAngle > 1 Then myActualJet.wingsAngle -= 0.1
                        Else
                            If myActualJet.wingsAngle < myActualJet.maxWingAngle Then myActualJet.wingsAngle += 0.3
                        End If

                        Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.left_wing_id, True, myActualJet.wingsAngle * (3.14 / 180)) ' wing 1cockpit_id
                        Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.right_wing_id, True, myActualJet.wingsAngle * (3.14 / 180)) ' wing 2
                    End If

                    ' move flaps
                    If (myActualJet.idleFlapsAngle > 0) AndAlso (myActualJet.minFlapsAngle > -1) AndAlso (myActualJet.maxFlapsAngle > 0) AndAlso (myActualJet.left_flap_id > -1) AndAlso (myActualJet.right_flap_id > -1) Then
                        If Game.isGameKeyPressed(GameKey.MoveLeft) OrElse Game.isKeyPressed(hkRollLeft) Then
                            Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.left_flap_id, True, myActualJet.minFlapsAngle * (3.14 / 180)) ' flap 1
                            If myActualJet.right_flap_id <> myActualJet.left_flap_id Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.right_flap_id, True, myActualJet.maxFlapsAngle * (3.14 / 180)) ' flap 2
                        ElseIf Game.isGameKeyPressed(GameKey.MoveRight) OrElse Game.isKeyPressed(hkRollRight) Then
                            Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.left_flap_id, True, myActualJet.maxFlapsAngle * (3.14 / 180)) ' flap 1
                            If myActualJet.right_flap_id <> myActualJet.left_flap_id Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.right_flap_id, True, myActualJet.minFlapsAngle * (3.14 / 180)) ' flap 2
                        ElseIf Game.isKeyPressed(hkJetMoveDown) OrElse Game.isKeyPressed(hkDown) Then
                            Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.left_flap_id, True, myActualJet.maxFlapsAngle * (3.14 / 180)) ' flap 1
                            If myActualJet.right_flap_id <> myActualJet.left_flap_id Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.right_flap_id, True, myActualJet.maxFlapsAngle * (3.14 / 180)) ' flap 2
                        ElseIf Game.isKeyPressed(hkJetMoveUp) OrElse Game.isKeyPressed(hkUp) Then
                            Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.left_flap_id, True, myActualJet.minFlapsAngle * (3.14 / 180)) ' flap 1
                            If myActualJet.right_flap_id <> myActualJet.left_flap_id Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.right_flap_id, True, myActualJet.minFlapsAngle * (3.14 / 180)) ' flap 2
                        Else
                            Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.left_flap_id, True, myActualJet.idleFlapsAngle * (3.14 / 180)) ' flap 1
                            If myActualJet.right_flap_id <> myActualJet.left_flap_id Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.right_flap_id, True, myActualJet.idleFlapsAngle * (3.14 / 180)) ' flap 2
                        End If
                    End If

                    ' move rudder
                    If (myActualJet.rudder_idle_angle > 0) AndAlso (myActualJet.rudder_min_angle > -1) AndAlso (myActualJet.rudder_max_angle > 0) Then
                        If Game.isGameKeyPressed(GameKey.MoveLeft) OrElse Game.isKeyPressed(hkTurnLeft) Then
                            If (myActualJet.rudder_1_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.rudder_1_id, True, myActualJet.rudder_min_angle * (3.14 / 180))
                            If (myActualJet.rudder_2_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.rudder_2_id, True, myActualJet.rudder_min_angle * (3.14 / 180))
                        ElseIf Game.isGameKeyPressed(GameKey.MoveRight) OrElse Game.isKeyPressed(hkTurnRight) Then
                            If (myActualJet.rudder_1_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.rudder_1_id, True, myActualJet.rudder_max_angle * (3.14 / 180))
                            If (myActualJet.rudder_2_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.rudder_2_id, True, myActualJet.rudder_max_angle * (3.14 / 180))
                        Else
                            If (myActualJet.rudder_1_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.rudder_1_id, True, myActualJet.rudder_idle_angle * (3.14 / 180))
                            If (myActualJet.rudder_2_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.rudder_2_id, True, myActualJet.rudder_idle_angle * (3.14 / 180))
                        End If
                    End If

                    ' move elevator
                    If (myActualJet.elevator_idle_angle > 0) AndAlso (myActualJet.elevator_min_angle > -1) AndAlso (myActualJet.elevator_max_angle > 0) Then
                        If Game.isGameKeyPressed(GameKey.MoveLeft) OrElse Game.isKeyPressed(hkTurnLeft) Then
                            If (myActualJet.elevator_1_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.elevator_1_id, True, myActualJet.elevator_min_angle * (3.14 / 180))
                            If (myActualJet.elevator_2_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.elevator_2_id, True, myActualJet.elevator_min_angle * (3.14 / 180))
                        ElseIf Game.isGameKeyPressed(GameKey.MoveRight) OrElse Game.isKeyPressed(hkTurnRight) Then
                            If (myActualJet.elevator_1_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.elevator_1_id, True, myActualJet.elevator_max_angle * (3.14 / 180))
                            If (myActualJet.elevator_2_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.elevator_2_id, True, myActualJet.elevator_max_angle * (3.14 / 180))
                        Else
                            If (myActualJet.elevator_1_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.elevator_1_id, True, myActualJet.elevator_idle_angle * (3.14 / 180))
                            If (myActualJet.elevator_2_id <> -1) Then Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.elevator_2_id, True, myActualJet.elevator_idle_angle * (3.14 / 180))
                        End If
                    End If

                    ' move gears
                    If (myActualJet.back_gears_r_id > -1) AndAlso (myActualJet.back_gears_l_id > -1) AndAlso (myActualJet.front_gears_r_id > -1) AndAlso (myActualJet.front_gears_l_id > -1) AndAlso _
                       (myActualJet.gears_closed_angle <> -100) AndAlso (myActualJet.gears_open_angle <> -100) Then
                        If (tmpJet.Position.DistanceTo(World.GetGroundPosition(tmpJet.Position, GroundType.Lowest)) < 50) OrElse Game.isGameKeyPressed(GameKey.MoveBackward) Then
                            If timeWaitCloseGears <= 0 Then
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_r_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_l_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_r_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' back gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_l_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' back gears

                                timeWaitOpenGears = 1000
                            Else
                                timeWaitCloseGears -= Me.Interval

                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_r_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_l_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_r_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' back gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_l_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' back gears
                            End If
                        Else
                            If timeWaitOpenGears <= 0 Then
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_r_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_l_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_r_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' back gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_l_id, True, myActualJet.gears_open_angle * (3.14 / 180)) ' back gears

                                timeWaitCloseGears = 1000
                            Else
                                timeWaitOpenGears -= Me.Interval

                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_r_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.front_gears_l_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' front gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_r_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' back gears
                                Native.Function.Call("CONTROL_CAR_DOOR", tmpJet, myActualJet.back_gears_l_id, True, myActualJet.gears_closed_angle * (3.14 / 180)) ' back gears
                            End If
                        End If
                    End If
                End If

                For Each j As TJet In jetList
                    If (j.timeRemove <> -1000) OrElse Not Exists(j.jet) OrElse Not Exists(j.p) Then Continue For

                    If Not j.isMP AndAlso (Not Exists(j.jet) OrElse Not Exists(j.p)) Then
                        j.timeRemove = 0

                        Continue For
                    End If

                    If j.jet.Health > 0 Then
                        j.jet.EngineHealth = 1000
                        j.jet.PetrolTankHealth = 1000
                    Else
                        explodeEnemyJet(j)
                    End If

                    For Each eng As engine In j.engines
                        Native.Function.Call("stop_ptfx", eng.ptfx)

                        eng.ptfx = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "muz_pistol_large", _
                            j.jet, eng.offPosition.X, eng.offPosition.Y, eng.offPosition.Z, 0, 0, -90.0, 2.0)

                        eng.engLight.Intensity = j.jet.Position.DistanceTo(Player.Character.Position)
                        'eng.engLight.position = eng.attachPoint.position
                        eng.engLight.Position = j.jet.GetOffsetPosition(eng.offPosition)
                    Next

                    ' flaps/gears
                    If j.jet.Position.DistanceTo(Player.Character.Position) < 250 Then
                        If (j.back_gear_l <> -1) AndAlso (j.gears_closed_angle <> -100) Then Native.Function.Call("CONTROL_CAR_DOOR", j.jet, j.back_gear_l, True, j.gears_closed_angle * (3.14 / 180))
                        If (j.back_gear_r <> -1) AndAlso (j.gears_closed_angle <> -100) Then Native.Function.Call("CONTROL_CAR_DOOR", j.jet, j.back_gear_r, True, j.gears_closed_angle * (3.14 / 180))
                        If (j.front_gear_l <> -1) AndAlso (j.gears_closed_angle <> -100) Then Native.Function.Call("CONTROL_CAR_DOOR", j.jet, j.front_gear_l, True, j.gears_closed_angle * (3.14 / 180))
                        If (j.front_gear_r <> -1) AndAlso (j.gears_closed_angle <> -100) Then Native.Function.Call("CONTROL_CAR_DOOR", j.jet, j.front_gear_r, True, j.gears_closed_angle * (3.14 / 180))
                        If j.flaps_r <> -1 Then Native.Function.Call("CONTROL_CAR_DOOR", j.jet, j.flaps_r, True, j.flap_idle_angle * (3.14 / 180))
                        If j.flaps_l <> -1 Then Native.Function.Call("CONTROL_CAR_DOOR", j.jet, j.flaps_l, True, j.flap_idle_angle * (3.14 / 180))
                    End If

                    If isInJet() Then
                        If Not j.isMP Then
                            If (j.timeWait <= 0) Then
                                j.timeWait = 250

                                ' if we are closer to the enemy jet than the enemy jet + his jet direction it means that we can pursuit him 
                                If (j.jet.Position + enemyDir(j)).DistanceTo(myJet.Position) > j.jet.Position.DistanceTo(myJet.Position) Then
                                    If j.is_hunter Then
                                        If j.jet.Position.DistanceTo(Player.Character.Position) < 400 Then
                                            ' make him evade
                                            j.p.Task.DriveTo((j.jet.Position + j.jet.Direction * (maxRoundForEvade + 100)).Around(maxRoundForEvade) + Vector3.WorldUp * jetList.IndexOf(j) * 4 + returnJetOffPos(j), 80.0, False) ' evade									
                                            ' limit his speed
                                            'if (j.jet.position.distanceto(myJet.position) > 25) andalso (j.jet.speed > 70) then j.jet.applyforce(j.jet.direction * -3)		

                                            j.actualSpeed = 0
                                        Else
                                            ' make him go back and try to pursuit the player
                                            j.p.Task.DriveTo((Player.Character.Position + Vector3.WorldUp * 5).Around(10) + Vector3.WorldUp * jetList.IndexOf(j) * 4 + returnJetOffPos(j), 80.0, False)

                                            j.actualSpeed = myJet.Speed * 0.5
                                        End If
                                    Else
                                        If j.jet.Position.DistanceTo(Player.Character.Position) < 2000 Then
                                            ' make him evade
                                            j.p.Task.DriveTo((j.jet.Position + j.jet.Direction * (maxRoundForFugitiveEvade + 100)).Around(maxRoundForFugitiveEvade) + Vector3.WorldUp * jetList.IndexOf(j) * 4 + returnJetOffPos(j), 80.0, False)

                                            ' if its too far away, reduce his speed
                                            'if (j.jet.position.distanceto(player.character.position) > 500) then
                                            '   j.actualSpeed = myJet.speed / 2
                                            'else									  
                                            '	j.actualSpeed = myJet.speed * 1.2
                                            'end if
                                        Else
                                            msg("Fugitive has escaped...", 3000)
                                            j.timeRemove = 0
                                        End If
                                    End If
                                Else ' in this case, the enemy is pursuiting the player
                                    If j.is_hunter Then
                                        ' if the enemy its too close, turn and try to follow again								
                                        If j.jet.Position.DistanceTo(Player.Character.Position) < 70 Then
                                            j.p.Task.DriveTo(j.jet.Position + j.jet.Direction * 100 - (j.jet.Direction * jetList.IndexOf(j) * 4) + returnJetOffPos(j), 10.0, False)

                                            j.actualSpeed = 120
                                        ElseIf j.jet.Position.DistanceTo(Player.Character.Position) < 150 Then
                                            j.p.Task.DriveTo((Player.Character.Position + myJet.Direction * 30) + Vector3.WorldUp * jetList.IndexOf(j) * 4 + _
                                                (Vector3.WorldUp * planeDir.z) - j.jet.Direction * jetList.IndexOf(j) * 10 + returnJetOffPos(j), 80.0, False) ' follow to shoot

                                            j.actualSpeed = 100
                                        Else
                                            j.p.Task.DriveTo((Player.Character.Position + planeDir() * 15).Around(10) + _
                                                Vector3.WorldUp * jetList.IndexOf(j) * 4 - j.jet.Direction * jetList.IndexOf(j) * 10 + returnJetOffPos(j), 80.0, False) ' go faster

                                            j.actualSpeed = myJet.Speed * 1.5
                                        End If
                                    Else ' fugitive behind the player
                                        If j.jet.Position.DistanceTo(Player.Character.Position) < 2000 Then
                                            j.p.Task.DriveTo((j.jet.Position - j.jet.Direction * 400).Around(300) + Vector3.WorldUp * jetList.IndexOf(j) * 4 - j.jet.Direction * jetList.IndexOf(j) * 10 + returnJetOffPos(j), _
                                                45.0, False)

                                            ' if its too far away, reduce his speed
                                            If (j.jet.Position.DistanceTo(Player.Character.Position) > 500) Then
                                                j.actualSpeed = myJet.Speed / 2
                                            Else
                                                j.actualSpeed = myJet.Speed
                                            End If
                                        Else
                                            msg("Fugitive has escaped...", 3000)
                                            j.timeRemove = 0
                                        End If
                                    End If
                                End If

                                If Native.Function.Call(Of Boolean)("IS_CAR_IN_WATER", j.jet) AndAlso (j.jet.Health > 0) Then
                                    explodeEnemyJet(j)
                                End If
                            Else
                                j.timeWait -= Me.Interval
                            End If
                        End If
                    End If

                    If Not j.isMP Then
                        ' control they speed
                        If j.is_hunter Then
                            If j.actualSpeed > 200 Then j.actualSpeed = 200

                            If j.actualSpeed > 100 Then Native.Function.Call("SET_CAR_FORWARD_SPEED", j.jet, j.actualSpeed)
                        End If

                        Dim tmpJetGroundDist As Double = j.jet.Position.DistanceTo(World.GetGroundPosition(j.jet.Position, GroundType.Lowest))
                        If tmpJetGroundDist < 150 Then
                            j.jet.ApplyForce(Vector3.WorldUp * (150 - tmpJetGroundDist) / 50) ' help him go up and dont crash the plane on the ground/sea
                        End If

                        If j.jet.Speed < 30 Then j.jet.ApplyForce(enemyDir(j) * (30 - j.jet.Speed)) ' help him go faster
                        If j.is_fugitive AndAlso (j.jet.Speed > 70) Then
                            j.jet.ApplyForce(enemyDir(j) * (70 - j.jet.Speed)) ' slow down
                        End If

                        ' enemy missile launch time wait
                        If j.timeWaitLaunch > 0 Then j.timeWaitLaunch -= Me.Interval

                        ' move enemy rockets
                        If enemyJet_shoot_rocket Then moveEnemyRockets(j)

                        If enemyJet_shoot_cannon OrElse enemyJet_shoot_rocket Then
                            'if (j.jet.position.distanceto(myJet.position) < 300) andalso (j.jet.position.distanceto(myJet.position) > 25) andalso _
                            '   (math.abs(j.jet.position.z - myjet.position.z) <= 45) then
                            ' enemy lock missile and shoot cannon
                            If (j.jet.Position.DistanceTo(myJet.Position) < 300) Then
                                ' here i check if the enemy jet its on a position close to the center of the player plane direction
                                ' this close position tis small when the enemy jet its close to the player, and bigger when far away
                                If myJet.Position.DistanceTo(j.jet.Position + enemyDir(j) * j.jet.Position.DistanceTo(myJet.Position)) < _
                                   (j.jet.Position.DistanceTo(myJet.Position) / 3) Then
                                    If j.timeMissileAlarmValue > 10 Then
                                        j.timeMissileAlarmValue -= 1.5

                                        If jetEnemyAttacking = j.jet Then
                                            jetEnemyAttacking = Nothing
                                        End If

                                        j.lockedOnTarget = False
                                    Else
                                        If enemyJet_shoot_rocket Then
                                            If jetEnemyAttacking = Nothing Then
                                                jetEnemyAttacking = j.jet
                                            End If

                                            j.lockedOnTarget = True
                                        End If
                                    End If

                                    If j.is_hunter Then
                                        If j.timeMissileAlarm >= j.timeMissileAlarmValue Then
                                            j.timeMissileAlarm = 0

                                            If timeWaitSoundRocket <= 0 Then If camMode <> 4 Then sndAlarm.Play() Else sndAlarm2.Play()

                                            bWarnEnemyMissileLock = True
                                        Else
                                            j.timeMissileAlarm += Me.Interval * (25 / Game.FPS)
                                        End If
                                    End If

                                    If enemyJet_shoot_cannon AndAlso (Math.Abs(j.jet.Position.Z - myJet.Position.Z) <= 10) Then
                                        If ((j.jet.Direction - Player.Character.Direction).DistanceTo(Vector3.Zero) <= 0.5) Then
                                            j.shoot20mm((Player.Character.Position + planeDir() * 10).Around(3), enemyJet_cannon_dmg)
                                        ElseIf ((j.jet.Direction - Player.Character.Direction).DistanceTo(Vector3.Zero) <= 0.2) Then
                                            j.shoot20mm((Player.Character.Position + planeDir() * 5).Around(1), enemyJet_cannon_dmg)
                                        End If
                                    End If
                                Else
                                    j.timeMissileAlarmValue = timeWaitMissileLock

                                    If jetEnemyAttacking = j.jet Then jetEnemyAttacking = Nothing

                                    j.lockedOnTarget = False
                                End If
                            Else
                                j.timeMissileAlarmValue = timeWaitMissileLock

                                If jetEnemyAttacking = j.jet Then jetEnemyAttacking = Nothing

                                j.lockedOnTarget = False
                            End If
                        End If
                    End If

                    ' player locking missiles on enemy jets
                    If (j.jet.Position.DistanceTo(myJet.Position) < 350) Then
                        ' same check made with enemy
                        If j.jet.Position.DistanceTo(myJet.Position + planeDir() * myJet.Position.DistanceTo(j.jet.Position)) < (myJet.Position.DistanceTo(j.jet.Position) / (3 / AimEase)) Then
                            If j.timeMissileLockValue > 10 Then
                                If Not Exists(TJetLocked) Then
                                    j.timeMissileLockValue -= 2
                                ElseIf Not TJetLocked.Equals(j) Then
                                    j.timeMissileLockValue = 300
                                End If

                                If Exists(TJetLocked) AndAlso TJetLocked.Equals(j) Then TJetLocked = Nothing
                            ElseIf Not Exists(TJetLocked) Then
                                TJetLocked = j
                            End If

                            If j.timeMissileLock >= j.timeMissileLockValue Then
                                j.timeMissileLock = 0

                                If timeWaitSoundRocket <= 0 Then If camMode <> 4 Then sndMissileLock.Play() Else sndMissileLock2.Play()

                                drawTargetedHUD(j.jet)

                                bWarnMyMissileLock = True
                            Else
                                j.timeMissileLock += Me.Interval * (25 / Game.FPS)
                            End If
                        Else
                            j.timeMissileLockValue = 300

                            If Exists(TJetLocked) AndAlso TJetLocked.Equals(j) Then TJetLocked = Nothing
                        End If
                    Else
                        j.timeMissileLockValue = 300

                        If Exists(TJetLocked) AndAlso TJetLocked.Equals(j) Then TJetLocked = Nothing
                    End If

                    ' enemy flare tick
                    If Not j.isMP AndAlso (j.timeOutFlare > 0) Then j.timeOutFlare -= Me.Interval
                Next

                If Not Exists(TJetLocked) Then
                    lockOnHeliTick()
                Else
                    For Each h As THeli In heliList
                        h.timeMissileLockValue = 300
                    Next
                End If

                If Game.isKeyPressed(hkShootCannon) OrElse ((currWeapon = 1) AndAlso Game.isKeyPressed(Keys.LButton)) AndAlso isJetOk() Then
                    If timeShoot20mm <= 0 Then
                        timeShoot20mm = 10

                        sndCannonPlay()

                        For Each c As cannon In myActualJet.cannList
                            If Not c.enabled Then Continue For

                            If c.shootTime = myActualJet.actualCannon Then
                                Native.Function.Call("stop_ptfx", c.ptfx)
                                Native.Function.Call("stop_ptfx", c.ptfxTrace)

                                Dim vecPosFin As Vector3

                                vecPosFin = Player.Character.Position + planeDir() * c.range

                                c.ptfx = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "muz_machine", _
                                    myJet, c.offPosition.X, c.offPosition.Y, c.offPosition.Z, 0, 0, 90.0, c.size)
                                c.ptfxTrace = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "wpn_bullet_trace", _
                                    myJet, c.offPosition.X, c.offPosition.Y, c.offPosition.Z, -90.0, 0, 0, c.trace_size)

                            '	native.function.call("FIRE_SINGLE_BULLET", c.attachPoint.position.x, c.attachPoint.position.y, c.attachPoint.position.z, _
                            '		vecPosFin.x, vecPosFin.y, vecPosFin.z, c.damage)
                            '	native.function.call("FIRE_SINGLE_BULLET", c.attachPoint.position.x, c.attachPoint.position.y, c.attachPoint.position.z, _
                            '		vecPosFin.x, vecPosFin.y, vecPosFin.z, c.damage)
                            '	native.function.call("FIRE_SINGLE_BULLET", c.attachPoint.position.x, c.attachPoint.position.y, c.attachPoint.position.z, _
                            '		vecPosFin.x, vecPosFin.y, vecPosFin.z, c.damage)
                                Dim tmpPos As Vector3 = myJet.GetOffsetPosition(c.offPosition)

                                Native.Function.Call("FIRE_SINGLE_BULLET", tmpPos.X, tmpPos.Y, tmpPos.Z, _
                                    vecPosFin.X, vecPosFin.Y, vecPosFin.Z, c.damage)
                                Native.Function.Call("FIRE_SINGLE_BULLET", tmpPos.X, tmpPos.Y, tmpPos.Z, _
                                    vecPosFin.X, vecPosFin.Y, vecPosFin.Z, c.damage)
                                Native.Function.Call("FIRE_SINGLE_BULLET", tmpPos.X, tmpPos.Y, tmpPos.Z, _
                                    vecPosFin.X, vecPosFin.Y, vecPosFin.Z, c.damage)
                            End If
                        Next

                        myActualJet.actualCannon += 1

                        If myActualJet.actualCannon > myActualJet.cannonCount Then myActualJet.actualCannon = 1
                    Else
                        timeShoot20mm -= Me.Interval * (25 / Game.FPS)
                    End If
                End If
            End If
        Else
            timeWaitMissileLock = 300
        End If

        If multi <> multiAux Then
            If multiAux > multi Then
                multi += 0.05

                If multiAux < multi Then multi = multiAux
            Else
                multi -= 0.05

                If multiAux > multi Then multi = multiAux
            End If
        End If

        If Exists(myJet) AndAlso Exists(myActualJet) Then
            If myJet.isOnAllWheels Then
                If (Game.isKeyPressed(Keys.Left) OrElse Game.isKeyPressed(Keys.Right)) Then
                    If Game.isKeyPressed(Keys.Left) Then
                        myJet.ApplyForce(myJet.Direction / 8, Vector3.WorldEast * 3.5)
                        myJet.ApplyForce(myJet.Direction / -18)
						bMustStop = false
                    ElseIf Game.isKeyPressed(Keys.Right) Then
                        myJet.ApplyForce(myJet.Direction / 8, Vector3.WorldWest * 3.5)
                        myJet.ApplyForce(myJet.Direction / -18)
						bMustStop = false
                    End If
                End If
            End If

            If Game.isGameKeyPressed(GameKey.MoveForward) Then
                If Game.isKeyPressed(Keys.Space) Then
                    multiAux = myActualJet.engineMaxFxSize * 1.5

                    soundOffsetAux = 13
                Else
                    multiAux = myActualJet.engineMaxFxSize

                    soundOffsetAux = 1
                End If
            ElseIf Game.isGameKeyPressed(GameKey.MoveBackward) Then
                multiAux = myActualJet.engineMinFxSize

                Native.Function.Call("stop_sound", IDSndJetAccel)
                timeWaitIDSndJetAccel = 0

                soundOffsetAux = 20
            Else
                multiAux = myActualJet.engineIdleFxSize

                Native.Function.Call("stop_sound", IDSndJetAccel)
                timeWaitIDSndJetAccel = 0

                soundOffsetAux = 15
            End If

            If myJet.Health < lastJetHealth Then
                If (myJet.Health <= 0) OrElse (lastJetHealth - myJet.Health > 200) Then
                    explodeMyJet()

                    If Exists(camGun) Then camGun.Deactivate()
                    camMode = 0

                    myJet = Nothing
                End If
            End If
        End If

        If isInJet() Then
            lastJetHealth = myJet.Health

            If soundOffset <> soundOffsetAux Then
                If soundOffsetAux > soundOffset Then
                    soundOffset += 0.1
                    If soundOffsetAux < soundOffset Then soundOffset = soundOffsetAux
                Else
                    soundOffset -= 0.1
                    If soundOffsetAux > soundOffset Then soundOffset = soundOffsetAux
                End If
            End If

            If timeWaitIDSndJetAccel <= 0 Then
                If myActualJet.soundJetIdle <> "" Then
                    Native.Function.Call("stop_sound", IDSndJetIdle)
                    Native.Function.Call("PLAY_SOUND_FROM_object", IDSndJetIdle, myActualJet.soundJetIdle, soundAuxIdle)
                End If

                If myActualJet.soundJetAccel <> "" Then
                    Native.Function.Call("stop_sound", IDSndJetAccel)
                    Native.Function.Call("PLAY_SOUND_FROM_object", IDSndJetAccel, myActualJet.soundJetAccel, soundAuxAceel)
                End If

                timeWaitIDSndJetAccel = 500
            Else
                timeWaitIDSndJetAccel -= Me.Interval
            End If

            If camMode = 0 Then
                soundAuxIdle.Position = Player.Character.Position + Game.CurrentCamera.Direction * (soundOffset * 0.5)
                soundAuxAceel.Position = Player.Character.Position + Game.CurrentCamera.Direction * soundOffset
                soundAuxAceel2.Position = Player.Character.Position + Game.CurrentCamera.Direction * soundOffset * 0.5
            ElseIf camMode = 4 Then
                soundAuxIdle.Position = Player.Character.Position - planeDir() * 5
                soundAuxAceel.Position = Player.Character.Position - planeDir() * 30
                soundAuxAceel2.Position = Player.Character.Position - planeDir() * 15
            Else
                soundAuxIdle.Position = Player.Character.Position - planeDir() * (soundOffset * 0.5) / 2
                soundAuxAceel.Position = Player.Character.Position - planeDir() * soundOffset / 2
                soundAuxAceel2.Position = Player.Character.Position - planeDir() * soundOffset * 0.5 / 2
            End If

            For Each eng As engine In myActualJet.engineList
                If Not eng.enabled Then Continue For

                Native.Function.Call("stop_ptfx", eng.ptfx)

                eng.ptfx = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "muz_pistol_large", _
                    myJet, eng.offPosition.X, eng.offPosition.Y, eng.offPosition.Z, 0, 0, -90.0, 1.0 * multi)
            Next
        Else
            soundOffsetAux = 20

            soundAuxAceel.Position = Player.Character.Position + Vector3.WorldUp * soundOffset - Player.Character.Direction * 60
            soundAuxAceel2.Position = Player.Character.Position + Vector3.WorldUp * soundOffset - Player.Character.Direction * 60
        End If
        Catch
            msg("AC-IV: An error occurred :(, reload the game...", 5000)
        End Try
    End Sub

    Private Sub checkSpaceTrip()
        If st_time_check_aux <= 0 Then
            st_time_check_aux = st_time_check

            If Not isInJet() Then Exit Sub

            If st_in_earth Then
                If Player.Character.Position.Z > st_height_teleport Then
                    st_in_earth = False

                    Game.FadeScreenOut(2000, True)

                    Try
                        myJet.Position = st_teleport_pos
                    Catch
                    End Try

                    Game.FadeScreenIn(500, False)
                End If
            Else
                If Player.Character.Position.Z < st_height_teleport_back Then
                    st_in_earth = True

                    Game.FadeScreenOut(2000, True)

                    Try
                        myJet.Position = st_teleport_pos_back
                    Catch
                    End Try

                    Game.FadeScreenIn(500, False)
                End If
            End If
        Else
            st_time_check_aux -= Me.Interval
        End If
    End Sub

    Private Sub checkJetAP()
        If timeSetAP > 0 Then timeSetAP -= Me.Interval

        For Each ap As TJetAP In TJetAPList
            If ap.cp.Visible AndAlso Not Exists(Player.Character.CurrentVehicle) AndAlso (Player.Character.Position.DistanceTo2D(ap.cp.Position) < (ap.diameter * 0.5)) _
               AndAlso (Math.Abs(Player.Character.Position.Z - ap.cp.Position.Z) <= 2) Then
                Game.FadeScreenOut(250, True)
                Wait(500)

                Try
                    For Each v2 As Vehicle In World.GetVehicles(ap.jetPos, ap.jetModel.GetDimensions.Y)
                        If Exists(v2) Then v2.Delete()
                    Next

                    Dim v As Vehicle = World.CreateVehicle(ap.jetModel, ap.jetPos)

                    v.Heading = ap.heading
                    Player.Character.WarpIntoVehicle(v, VehicleSeat.Driver)

                    Game.FadeScreenIn(250, False)
                    Wait(500)
                Catch
                    Game.FadeScreenIn(250, False)
                    Wait(500)
                    msg("An error occured, try again.", 3000)
                    Player.Character.Position = Player.Character.Position - Player.Character.Direction * (ap.diameter - Player.Character.Position.DistanceTo(ap.cp.Position) + 1)
                End Try
            End If

            If timeSetAP <= 0 Then
                ap.cp.Position = ap.checkPos
                ap.cp.Diameter = ap.diameter
                ap.cp.Color = Color.FromArgb(ap.cpAlpha, ap.cpRcolor, ap.cpGcolor, ap.cpBcolor)
                ap.cp.Visible = ap.checkPVisible

                If ap.autoCreateJet AndAlso Not Exists(ap.createdJet) Then
                    For Each v2 As Vehicle In World.GetVehicles(ap.jetPos, 10.0)
                        If Exists(v2) Then v2.Delete()
                    Next

                    ap.createdJet = World.CreateVehicle(ap.jetModel, ap.jetPos)
                    ap.resetPosition = True
                End If

                resetAPJet(ap)
            End If
        Next

        If timeSetAP <= 0 Then timeSetAP = 500
    End Sub

    Private Sub resetAPJet(ByVal ap As TJetAP)
        Try
            If Exists(ap.createdJet) AndAlso ap.resetPosition AndAlso (Player.Character.Position.DistanceTo(ap.jetPos) < 500) Then
                ap.resetPosition = False

                'for each v2 as vehicle in world.getvehicles(ap.jetPos, 10.0)
                '	if exists(v2) andalso (v2 <> ap.createdJet) then v2.delete
                'next

                ap.createdJet.Position = ap.jetPos
                ap.createdJet.Heading = ap.heading
                ap.createdJet.Repair()
            End If
        Catch
        End Try
    End Sub

    Private Sub checkHeli()
        Try
            Dim h As THeli = Nothing

            For c As Int16 = heliList.Count - 1 To 0 Step -1
                h = heliList(c)

                If Not Exists(h.heli) OrElse (h.heli.Health <= 0) OrElse (h.heli.EngineHealth <= 0) OrElse (h.heli.PetrolTankHealth <= 0) Then
                    If Exists(h.heliBlip) Then h.heliBlip.Delete()

                    If Exists(h.heli) AndAlso (h.heli = heliLocked) Then heliLocked = Nothing

                    'If Exists(h.checkPAux) Then h.checkPAux.Visible = False
                    heliList.RemoveAt(c)
                End If
            Next
        Catch
        End Try
    End Sub

    Private Sub lockOnHeliTick()
        Dim h As THeli = Nothing

        For c As Int16 = heliList.Count - 1 To 0 Step -1
            h = heliList(c)

            If Exists(h.heli) AndAlso (h.heli.Health > 0) AndAlso (h.heli.EngineHealth > 0) AndAlso (h.heli.PetrolTankHealth > 0) Then
                If (h.heli.Position.DistanceTo(myJet.Position) < 700) Then
                    If Not h.isMP AndAlso (h.heli.Speed > 1) AndAlso (h.heli.Speed < 40) Then h.heli.ApplyForce(h.heli.Direction)

                    If h.heli.Position.DistanceTo(myJet.Position + planeDir() * myJet.Position.DistanceTo(h.heli.Position)) < (myJet.Position.DistanceTo(h.heli.Position) / (3 * AimEase)) Then
                        If h.timeMissileLockValue > 10 Then
                            If Not Exists(heliLocked) Then
                                h.timeMissileLockValue -= 2
                            ElseIf heliLocked <> h.heli Then
                                h.timeMissileLockValue = 300
                            End If

                            If heliLocked = h.heli Then heliLocked = Nothing
                        Else
                            If Not Exists(heliLocked) Then heliLocked = h.heli
                        End If

                        If h.timeMissileLock >= h.timeMissileLockValue Then
                            h.timeMissileLock = 0

                            If timeWaitSoundRocket <= 0 Then If camMode <> 4 Then sndMissileLock.Play() Else sndMissileLock2.Play()

                            drawTargetedHUD(h.heli)

                            bWarnMyMissileLock = True
                        Else
                            h.timeMissileLock += Me.Interval * (25 / Game.FPS)
                        End If
                    Else
                        h.timeMissileLockValue = 300

                        If heliLocked = h.heli Then heliLocked = Nothing
                    End If

                    If Exists(myJet) AndAlso (myJet.Speed > 30) AndAlso h.heli.isTouching(myJet) Then explodeMyJet()
                ElseIf (h.heli.Position.DistanceTo(myJet.Position) > 2000) Then
                    If Not h.isMP Then
                        h.heli.NoLongerNeeded()

                        For Each p As Ped In World.GetPeds(h.heli.Position, 15.0)
                            If Exists(p) AndAlso (p.CurrentVehicle = h.heli) AndAlso Not Exists(p.GetControllingPlayer) Then
                                 p.NoLongerNeeded()
                            End If
                        Next
                    End If
                Else
                    h.timeMissileLockValue = 300

                    If heliLocked = h.heli Then heliLocked = Nothing
                End If

                If h.heli.isOnScreen AndAlso (h.heli.Position.DistanceTo(myJet.Position) > drawEnemyRectDist) Then
                '	dim float_temp_1 as double
                '	dim TO_RADIAN = 0.017453292519943295
                '	float_temp_1 = Math.Atan2((h.heli.Position.Y - Player.Character.Position.Y) , (h.heli.Position.X - Player.Character.Position.X))
                '	float_temp_1 = float_temp_1 - Game.CurrentCamera.Rotation.Z * TO_RADIAN
                '	float_temp_1 += 1.570796
                '	
                '	dim cam as camera = game.currentcamera
                '	dim dist as double = h.heli.position.distanceto(cam.position)
                '	dim compPos as vector3 = (cam.position + cam.direction * dist)
                '	dim y as double = (((compPos - h.heli.position).z)) / dist
                '	
                '	GTA.Native.Function.Call("DRAW_RECT", 0.5f + 0.7f * (Math.Sin(float_temp_1)), y + 0.55, 0.01, 0.02, 255, 150, 0, 100)

                    'h.checkPAux.Visible = True
                    'h.checkPAux.Position = h.heli.Position
                    'h.checkPAux.Diameter = h.heli.Position.DistanceTo(Player.Character.Position) / 60
                    Native.Function.Call("DRAW_CHECKPOINT", h.heli.Position.X, h.heli.Position.Y, h.heli.Position.Z, h.heli.Position.DistanceTo(Player.Character.Position) / 60, 255, 150, 0)
                'Else
                    'h.checkPAux.Visible = False
                End If
            End If
        Next
    End Sub

    Private Sub explodeMyJet()
        If Exists(camGun) Then camGun.Deactivate()
        camMode = 0

        If Not bExplodeMyJet Then
            Exit Sub
        Else
            bExplodeMyJet = False
        End If

        TJetLocked = Nothing

        If Exists(myFakeJet) AndAlso (myActualJet.use_fake_jet) Then
            myFakeJet.Visible = False
            myJet.Visible = True
        End If

        If isInJet() Then
            Player.Character.Task.ClearAllImmediately()
            Player.Character.Detach()
            Player.Character.Visible = False
            Player.Character.Die()
            Player.Character.FreezePosition = True
            bResetPL = True
        End If

        Native.Function.Call("stop_sound", IDSndJetIdle)
        Native.Function.Call("stop_sound", IDSndJetAccel)
        Native.Function.Call("stop_sound", IDSndJetAccel2)

        If isInJet() Then
            camDeath.Deactivate()
            camDeath.Position = (myJet.Position + planeDir() * 15 + Vector3.WorldUp * 5).Around(10)
            camDeath.LookAt(myJet)
            camDeath.Activate()
            Game.TimeScale = 0.2
        End If

        Dim resRot As Vector3 = myJet.Rotation
        Dim resHeading As Double = myJet.Heading
        Dim resSpeed As Double = myJet.Speed

        World.AddExplosion(myJet.Position, ExplosionType.Rocket, 1.0)
        Native.Function.Call("stop_ptfx", PTFXMyExp)
        PTFXMyExp = Native.Function.Call(Of Int32)("start_PTFX_ON_VEH", "exp_ship_destroy", _
            myJet, 0, 0, 0, 0, 0, 0, 1.0)
        myJet.Explode()
        Native.Function.Call("stop_ptfx", PTFXMyJetSmoke)
        Native.Function.Call("stop_ptfx", PTFXMyJetFire)
        PTFXMyJetSmoke = 0
        PTFXMyJetFire = 0

        For Each v As Vehicle In World.GetVehicles(myJet.Position, 10.0)
            If Exists(v) Then
                World.AddExplosion(v.Position, ExplosionType.Rocket, 1.0)
                v.Explode()
            End If
        Next

        For Each r As MR In myActualJet.MRL
            If r.enabled Then Native.Function.Call("stop_ptfx", r.ptfxID)
        Next

        For Each e As engine In myActualJet.engineList
            If e.enabled Then Native.Function.Call("stop_ptfx", e.ptfx)
        Next

        For Each j As TJet In jetList
            'j.checkPAux.Visible = False

            If Exists(j.jet) AndAlso Exists(j.p) Then
                If Not j.isMP Then j.p.Task.DriveTo((j.jet.Position + j.jet.Direction * 1000).Around(100), 80.0, False) ' fly away

                j.timeRemove = 0
            End If
        Next

        Native.Function.Call("stop_ptfx", PTFXWater)

        Wait(100)
        myJet.Rotation = resRot
        myJet.Heading = resHeading
        myJet.Speed = resSpeed
        myJet.ApplyForce(Vector3.WorldDown * 10, Vector3.WorldEast * 300 + Vector3.WorldNorth * 300)

        clearHeliList()
    End Sub

    Private Sub explodeEnemyJet(ByVal j As TJet, Optional ByVal jet As Vehicle = Nothing)
        Try
            If jet <> Nothing Then
                For c As Int16 = 0 To jetList.Count - 1
                    If jetList(c).jet = jet Then
                        j = jetList(c)
                        Exit For
                    End If
                Next
            End If

            If Not j.bExplodeJet Then
                Exit Sub
            Else
                j.bExplodeJet = False
            End If

            If j.DamagedByPlayer Then
                If timeWaitMissileLock > 125 Then timeWaitMissileLock -= 25 Else timeWaitMissileLock = 125
            End If

            j.resetRot = j.jet.Rotation
            j.resetHeading = j.jet.Heading
            j.resetSpeed = j.jet.Speed
            j.timeResetRot = 100
            World.AddExplosion(j.jet.Position, ExplosionType.Rocket, 1.0)
            j.PTFXExp = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "exp_ship_destroy", j.jet, 0, 0, 0, 0, 0, 0, 2.0)
            j.jet.Explode()
            Native.Function.Call("stop_ptfx", j.PTFXSmoke)
            Native.Function.Call("stop_ptfx", j.PTFXFire)
            Native.Function.Call("stop_ptfx", j.PTFXExp)
            j.PTFXSmoke = 0
            j.PTFXFire = 0
            j.PTFXExp = 0

            If Exists(j.p) Then j.p.Die()

            j.jet.ApplyForce(Vector3.WorldDown * 20)

            For Each r As MR In j.rockets
                Native.Function.Call("stop_ptfx", r.ptfxID)
            Next

            For Each e As engine In j.engines
                Native.Function.Call("stop_ptfx", e.ptfx)

                e.engLight.Enabled = True
            Next
        Catch
        End Try
    End Sub

    Private Sub moveEnemyRockets(ByVal j As TJet)
        For Each r As MR In j.rockets
            If Exists(jetEnemyAttacking) AndAlso (j.timeWaitLaunch <= 0) AndAlso Not r.launched AndAlso j.lockedOnTarget Then
                r.launch(planeDir, True)
                r.timeOut = 3000
                j.timeWaitLaunch = enemyJet_rocket_timewait

                Native.Function.Call("stop_sound", IDsndRocketMoveEnemy)
                Native.Function.Call("PLAY_SOUND_FROM_object", IDsndRocketMoveEnemy, myActualJet.soundRocketMove, r.rocket)

                Exit For
            End If

            If r.launched Then
                If r.propulsor_effect_size > 0 Then
                    'if r.timeResetPTFX <= 0 then
                        'r.timeResetPTFX = 50
                        'native.function.call("stop_ptfx", r.ptfxID)							
                        'r.ptfxID = native.function.call(of int32)("START_PTFX_ON_OBJ", "weap_rocket_player", r.rocket, 0, 0, 0, 0, 0, 0, r.propulsor_effect_size)
                    'else
                        'r.timeResetPTFX -= me.interval
                    'end if
                End If

                If (r.rocket.Position.DistanceTo(j.jet.Position) > 15) AndAlso _
                   (Native.Function.Call(Of Boolean)("HAS_OBJECT_COLLIDED_WITH_ANYTHING", r.rocket) OrElse (r.timeOut <= 0)) Then
                    r.ptfxExpID = Native.Function.Call(Of Int32)("START_PTFX", "exp_ship_destroy", r.rocket.Position.X, r.rocket.Position.Y, r.rocket.Position.Z, 0, 0, 0, 1.0)
                    World.AddExplosion(r.rocket.Position, ExplosionType.Rocket, 0.001, True, True, 1.0)

                    If r.rocket.Position.DistanceTo(myJet.Position) < 10 Then
                        r.ptfxExpID = Native.Function.Call(Of Int32)("start_PTFX_ON_veh", "exp_ship_destroy", _
                            myJet, 0, 0, 0, 0, 0, 0, 0.5)

                        myJet.Health -= random(enemyJet_rocket_damage - 100, enemyJet_rocket_damage)
                        'myJet.enginehealth -= random(enemyJet_rocket_damage - 100, enemyJet_rocket_damage)
                        'myJet.petroltankhealth -= random(enemyJet_rocket_damage - 100, enemyJet_rocket_damage)

                        If myJet.Health > 0 Then
                            myJet.EngineHealth = 1000
                            myJet.PetrolTankHealth = 1000
                        Else
                            explodeMyJet()
                        End If

                        lastJetHealth = myJet.Health
                    End If

                    r.attach(j.jet)

                    Native.Function.Call("stop_sound", IDsndRocketMoveEnemy)

                    j.timeWaitLaunch = enemyJet_rocket_timewait
                End If

                If r.timeOut > 0 Then
                    If Exists(jetEnemyAttacking) AndAlso (jetEnemyAttacking = j.jet) Then
                        r.timeOut -= Me.Interval
                    Else
                        r.timeOut -= (Me.Interval / 3)
                    End If

                    Dim tmpDirection As Vector3

                    If Exists(jetEnemyAttacking) Then
                        Dim distTmp As Double = r.rocket.Position.DistanceTo(myJet.Position)
                        Dim flareDist As Double = -1

                        If myFlareReleased Then
                            flareDist = myFlares(0).flareObj.Position.DistanceTo(myJet.Position)

                            If (flareDist > 400) Then
                                myFlareReleased = False

                                'native.function.call("stop_ptfx", PTFXMyFlare)
                                For Each f As Flare In myFlares
                                    Native.Function.Call("stop_ptfx", f.PTFXFlare)

                                    myFlaresResetList.Add(f)
                                Next

                                If (myFlares(0).flareObj.Position.DistanceTo(r.rocket.Position) < 50) Then jetEnemyAttacking = Nothing
                            Else
                                If myFlares(0).flareObj.Position.DistanceTo(r.rocket.Position) < 10 Then
                                    'native.function.call("stop_ptfx", PTFXMyFlare)
                                    'for each f as flare in myFlares
                                    '	native.function.call("stop_ptfx", f.PTFXFlare)
                                    'next

                                    r.timeOut = 0
                                End If
                            End If
                        End If

                        If myFlareReleased AndAlso ((flareDist < 150) OrElse (myFlares(0).flareObj.Position.DistanceTo(r.rocket.Position) < 150)) Then
                            tmpDirection = (myFlares(0).flareObj.Position - r.rocket.Position) / (distTmp / 3)
                        Else
                            tmpDirection = (myJet.Position - r.rocket.Position) / (distTmp / 3)
                        End If

                        'if myJet.speed > 250 then
                            r.final_dir = r.dir + tmpDirection * j.jet.Speed * 1.15 * r.speed_multiplier
                        'else
                        '	r.final_dir = r.dir + tmpDirection * myJet.speed * 1.5 * r.speed_multiplier
                        'end if

                        r.fixRotation = Helper.DirectionToRotation(Vector3.Normalize(r.final_dir), 0)

                        Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, r.final_dir.X, r.final_dir.Y, r.final_dir.Z)

                        If r.rocket.Position.DistanceTo(myJet.Position) < 5 Then
                            r.timeOut = 0
                        End If
                    Else
                        If r.final_dir <> Vector3.Zero Then
                            Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, r.final_dir.X, r.final_dir.Y, r.final_dir.Z)

                            r.fixRotation = Helper.DirectionToRotation(Vector3.Normalize(r.final_dir), 0)
                        Else
                            Native.Function.Call("SET_OBJECT_INITIAL_VELOCITY", r.rocket, _
                                r.dir.X * j.jet.Speed * r.speed_multiplier, _
                                r.dir.Y * j.jet.Speed * r.speed_multiplier, _
                                r.dir.Z * j.jet.Speed * r.speed_multiplier)

                            r.fixRotation = Helper.DirectionToRotation(Vector3.Normalize(r.dir), 0)
                        End If
                    End If

                    r.rocket.Rotation = r.fixRotation

                    If Native.Function.Call(Of Boolean)("IS_OBJECT_IN_WATER", r.rocket) Then r.timeOut = 0
                End If
            End If
        Next
    End Sub

    Private Sub setJet()
        If Exists(Player.Character.CurrentVehicle) AndAlso Not isInJet() Then
            myActualJet = Nothing

            For Each j As TCustomJetCFG In TCustomJetCFGList
                If Player.Character.CurrentVehicle.Model = j.jetModel Then
                    myActualJet = j
                    Exit For
                End If
            Next

            If Not Exists(myActualJet) Then Exit Sub

            bWaterImpact = False
            myJet = Player.Character.CurrentVehicle
            myJet.Metadata.falling = False

            ' this fake jet its just to avoid the wing/flaps break when landing the jet
            ' i hide the original jet (that have collisions) and i make visible this fake jet (that cant be damaged and touched) in the center of the original jet
            If myActualJet.use_fake_jet Then
                If Not Exists(myFakeJet) Then myFakeJet = World.CreateVehicle(myActualJet.jetModel, Player.Character.Position + Vector3.WorldUp * 100)
                Wait(50)
                If Not Exists(myFakeJet) Then myFakeJet = World.CreateVehicle(myActualJet.jetModel, Player.Character.Position + Vector3.WorldUp * 100)
            End If

            If Exists(myFakeJet) AndAlso myActualJet.use_fake_jet Then
                myFakeJet.Repair()
                myFakeJet.CanBeDamaged = False
                myFakeJet.CanBeVisiblyDamaged = False
                myFakeJet.Visible = True
                myFakeJet.Dirtyness = 0
                Native.Function.Call("ATTACH_CAR_TO_CAR", myFakeJet, myJet, False, 0, 0, 0, 0, 0, 0)
                myJet.Visible = False
                myJet.Metadata.invisible = True
            End If

            lastJetHealth = myJet.Health

            For Each r As MR In myActualJet.MRL
                If Not Exists(r.rocket) Then
                    r.rocket = World.CreateObject(r.model_name, Player.Character.Position.Around(5) + Vector3.WorldUp * 100)
                    r.rocket.Visible = False

                    Wait(50)
                End If

                Native.Function.Call("stop_ptfx", r.ptfxExpID)
                r.attach(myJet)
            Next

            'for each c as cannon in cannList
            '	c.attachPoint.detach
            '	native.function.call("ATTACH_OBJECT_TO_CAR", c.attachPoint, myJet, 0, c.x, c.y, c.z, 0, 0, 0)
            'next

        '	if not exists(planeDirAuxFront) then planeDirAuxFront = world.createobject("cj_rpg_rocket", player.character.position.around(5) + vector3.worldup * 50)
        '	if not exists(planeDirAuxCenter) then planeDirAuxCenter = world.createobject("cj_rpg_rocket", player.character.position.around(5) + vector3.worldup * 50)
        '	if not exists(planeDirAuxUp) then planeDirAuxUp = world.createobject("cj_rpg_rocket", player.character.position.around(5) + vector3.worldup * 50)
            'if not exists(myFlareObj) then myFlareObj = world.createobject("cj_rpg_rocket", player.character.position.around(5) + vector3.worldup * 50)

            If myFlares.Count = 0 Then
                For c As Int16 = 1 To 5
                    tmpFlare = New Flare
                    myFlares.Add(tmpFlare)
                Next
            End If

            For Each f As Flare In myFlares
                If Not Exists(f.flareObj) Then f.flareObj = World.CreateObject("cj_proc_brick", Player.Character.Position.Around(5) + Vector3.WorldUp * 50)
            Next
        '	
        '	planeDirAuxFront.attachtovehicle(myjet, vector3.relativeback, vector3.zero)
        '	planeDirAuxCenter.attachtovehicle(myjet, vector3.zero, vector3.zero)
        '	planeDirAuxUp.attachtovehicle(myjet, vector3.worldup, vector3.zero)

            For Each f As Flare In myFlares
                f.flareObj.AttachToVehicle(myJet, Vector3.WorldDown, Vector3.Zero)
                f.flareObj.Visible = False
            Next

        '	planeDirAuxFront.visible = false
        '	planeDirAuxCenter.visible = false
        '	planeDirAuxUp.visible = false


            myJet.Metadata.isAnJet = True

            'player.character.weapons.removeall

            actualJetSpeed = myJet.Speed

            Player.IgnoredByEveryone = True

            timeWaitOpenGears = 0
            timeWaitCloseGears = 0

            soundOffsetAux = 20
            soundOffset = 20
            timeWaitIDSndJetAccel = 0

            If myActualJet.soundJetAccel2 <> "" Then _
   Native.Function.Call("PLAY_SOUND_FROM_object", IDSndJetAccel2, myActualJet.soundJetAccel2, soundAuxAceel2)

            If Game.CurrentEpisode <> GameEpisode.GTAIV Then
                ' this two lines, thx to Nevitro and his simple parachute giver :)
                ' http://www.gtagarage.com/mods/show.php?id=11910
                Player.Character.Weapons.Item(41).Ammo = 1
                Player.Character.Weapons.Item(41).Select()
            End If

            myJet.DoorLock = DoorLock.ImpossibleToOpen

            Native.Function.Call("stop_sound", IDsndRocketMoveEnemy)
            Native.Function.Call("stop_sound", IDsndRocketMove)

            st_in_earth = Player.Character.Position.Z < st_height_teleport

            While Not Player.Character.isSittingInVehicle(myJet)
                Wait(100)
            End While
        End If
    End Sub

    Private Sub searchForOtherJets()
        Dim tmpPilot As Ped = Nothing

        For Each j As TJet In jetList
            If Not Exists(j.jet) OrElse (Not j.isMP AndAlso Not Exists(j.p)) Then j.timeRemove = 0
        Next

        For Each customJet As TCustomJetCFG In TCustomJetCFGList
            For Each v As Vehicle In World.GetAllVehicles(customJet.jetModel)
                If (v <> myJet) AndAlso Exists(v) AndAlso (v.Health > 0) AndAlso Not v.Metadata.isAnJet Then
                    Dim tmpExistJet As TJet = Nothing

                    For Each j As TJet In jetList
                        If j.jet = v Then
                            tmpExistJet = j
                            Exit Sub
                        End If
                    Next

                    tmpPilot = v.GetPedOnSeat(VehicleSeat.Driver)

                    If Exists(tmpExistJet) AndAlso Exists(tmpPilot) AndAlso Not tmpPilot.Metadata.IsJetPilot Then
                        If Not Exists(tmpExistJet) Then
                            tmpJet = New TJet
                            resetEnemyFlare(tmpJet)
                        Else
                            tmpExistJet.jetblip.Delete()
                        End If

                        tmpJet.jet = v
                        tmpJet.p = tmpPilot
                        tmpJet.is_hunter = False
                        tmpJet.is_fugitive = False
                        tmpJet.bAutoSpawn = False
                        tmpJet.isMP = True
                        tmpJet.jetblip = v.AttachBlip
                        tmpJet.jetblip.Color = BlipColor.Grey
                        tmpJet.checkPAux.Color = Color.FromArgb(100, 100, 100, 100)
                        tmpJet.checkPAux.Visible = True
                        tmpJet.checkPAux.Diameter = 10

                        If Not Exists(tmpExistJet) Then jetList.Add(tmpJet)
                    End If
                End If
            Next
        Next

        ' search for helis	
		if isInJet then
			searchHeliAux("annihilator")
			searchHeliAux("maverick")
			searchHeliAux("polmav")
			searchHeliAux("tourmav")
		end if
    End Sub

    Private Sub searchHeliAux(ByVal sModelName As String)
        If Not st_in_earth Then Exit Sub

        For Each v As Vehicle In World.GetAllVehicles(sModelName)
            If Exists(v) AndAlso Not isHeliAdded(v) AndAlso (v.Health > 0) Then
                If isInJet() Then v.isRequiredForMission = True

                tmpHeli = New THeli(v)
                v.Metadata.isAnHeli = True

                For Each p As Ped In World.GetPeds(v.Position, 15.0)
                    If Exists(p) AndAlso (p.CurrentVehicle = v) Then
                        tmpHeli.isMP = Exists(p.GetControllingPlayer)

                        'if not tmpHeli.isMP then p.becomemissioncharacter
                    End If
                Next

                'tmpHeli.checkPAux.Visible = True
                'tmpHeli.checkPAux.Diameter = 10
                'tmpHeli.checkPAux.Color = Color.FromArgb(100, 255, 150, 0)

                tmpHeli.timeMissileLockValue = 300
                tmpHeli.timeMissileLock = 300

                If isInJet() AndAlso Not tmpHeli.isMP Then tmpHeli.heli.Position = (Player.Character.Position + Player.Character.Direction * 300).Around(300) + Vector3.WorldUp * random(20, 100)

                heliList.Add(tmpHeli)
            End If
        Next
    End Sub

    Private Function isHeliAdded(ByVal v As Vehicle)
        For Each h As THeli In heliList
            If Exists(h.heli) AndAlso (h.heli = v) Then Return True
        Next

        Return False
    End Function

    Private Function planeDir()
        Return myJet.GetOffsetPosition(Vector3.RelativeFront) - myJet.Position

    '	if exists(planeDirAuxFront) andalso exists(planeDirAuxCenter) then			
    '		return planeDirAuxCenter.position - planeDirAuxFront.position
    '	else
    '		return player.character.currentvehicle.direction
    '	end if
    End Function

    Private Function planeDirUp()
        Return myJet.GetOffsetPosition(Vector3.RelativeTop) - myJet.Position

    '	if exists(planeDirAuxUp) andalso exists(planeDirAuxCenter) then			
    '		return planeDirAuxUp.position - planeDirAuxCenter.position
    '	else
    '		return player.character.currentvehicle.direction
    '	end if
    End Function

    Private Function enemyDir(ByVal enemy As TJet)
        Return enemy.jet.GetOffsetPosition(Vector3.RelativeFront) - enemy.jet.Position
    '	if exists(enemy.dirObj) andalso exists(enemy.dirObjCenter) then		
    '		return enemy.dirObj.position - enemy.dirObjCenter.position
    '	else
    '		return enemy.jet.direction
    '	end if
    End Function

    Private Function isInJet()
        Return Exists(Player.Character.CurrentVehicle) AndAlso Exists(myActualJet) AndAlso (Player.Character.CurrentVehicle = myJet) AndAlso (Player.Character.isSittingInVehicle(myJet))
    End Function

    Private Function isJetOk()
        Return Exists(myJet) AndAlso (myJet = Player.Character.CurrentVehicle) AndAlso (myJet.Health > 0) AndAlso (myJet.EngineHealth > 0) AndAlso (myJet.PetrolTankHealth > 0)
    End Function

    Private Sub JetLowHealthEffects()
        'dim tmpJetHealthAux as double = (myJet.health + myJet.enginehealth + myJet.petroltankhealth) / 3000
        Dim tmpJetHealthAux As Double = (myJet.Health) / 1000

        If tmpJetHealthAux < 0 Then tmpJetHealthAux = 0

        If (tmpJetHealthAux <= 0.5) AndAlso (PTFXMyJetSmoke = 0) Then
            PTFXMyJetSmoke = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "ambient_steam_vent_oblong", _
                myJet, 0, 0, 0, 0, 0, 0, 2.0)
        End If

        If (tmpJetHealthAux <= 0.2) AndAlso (PTFXMyJetFire = 0) Then
            PTFXMyJetFire = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "ambient_fire_generic", _
                myJet, 0, 0, 0, 0, 0, 0, 2.0)
        End If
    End Sub

    Private Sub drawTargetedHUD(ByVal target As Vehicle)
        camObjectAux.Position = Game.CurrentCamera.Position - Game.CurrentCamera.Direction * 20
        camObjectAux.Rotation = Game.CurrentCamera.Rotation

        Dim tmpTargetPos As Vector3 = target.Position
        Dim tmpDistCoef As Double = target.Position.DistanceTo(Game.CurrentCamera.Position) / 125

        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeTop * 3))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)
        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeTop * 3))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)
        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeBottom * 9))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)
        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeBottom * 3))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)

        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeTop * 6))
        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeRight * 3))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)
        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeRight * 3))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)

        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeLeft * 9))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)
        tmpTargetPos += (camObjectAux.Position - camObjectAux.GetOffsetPosition(Vector3.RelativeLeft * 3))
        Native.Function.Call("DRAW_CHECKPOINT", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 1 * tmpDistCoef, 255, 0, 0)
        'Native.Function.Call("draw_corona", tmpTargetPos.X, tmpTargetPos.Y, tmpTargetPos.Z, 300.0 * tmpDistCoef, 0, 0, 255, 0, 0)
    End Sub

    Private Sub EnemyJetTick()
        For c As Int16 = jetList.Count - 1 To 0 Step -1
            If Not jetList(c).isMP Then
                If (jetList(c).timeRemove <> -1000) Then ' counting to remove the FX and remove from the list
                    If (jetList(c).timeRemove <= 0) Then ' if reaches 0, remove
                        removeJet(c)

                        Exit For
                    Else
                        jetList(c).timeRemove -= Me.Interval

                        If (jetList(c).resetRot <> Vector3.Zero) Then
                            If jetList(c).timeResetRot <= 0 Then
                                jetList(c).jet.Rotation = jetList(c).resetRot
                                jetList(c).jet.Heading = jetList(c).resetHeading
                                jetList(c).jet.Speed = jetList(c).resetSpeed
                                jetList(c).jet.ApplyForce(Vector3.WorldDown * 10, Vector3.WorldEast * 300 + Vector3.WorldNorth * 300)
                                jetList(c).resetRot = Vector3.Zero
                                jetList(c).timeResetRot = 0
                            Else
                                jetList(c).timeResetRot -= Me.Interval
                            End If
                        End If
                    End If
                Else
                    'dim tmpJetHealthAux as double = (jetList(c).jet.health + jetList(c).jet.enginehealth + jetList(c).jet.petroltankhealth) / 3000
                    Dim tmpJetHealthAux As Double = (jetList(c).jet.Health) / 1000

                    If tmpJetHealthAux <= 0 Then
                        tmpJetHealthAux = 0

                        If Exists(TJetLocked) AndAlso TJetLocked.Equals(jetList(c)) Then TJetLocked = Nothing
                        If jetEnemyAttacking = jetList(c).jet Then jetEnemyAttacking = Nothing

                        If jetList(c).jet.Position.DistanceTo(myJet.Position) < 500 Then
                            For d As Int16 = 0 To 5
                                Native.Function.Call("break_car_door", jetList(c).jet, d, False)
                            Next

                            explodeEnemyJet(jetList(c))
                        Else
                            Native.Function.Call("stop_ptfx", jetList(c).PTFXSmoke)
                            Native.Function.Call("stop_ptfx", jetList(c).PTFXFire)
                            Native.Function.Call("stop_ptfx", jetList(c).PTFXExp)
                        End If

                        jetList(c).timeRemove = 4000
                    Else
                        If (tmpJetHealthAux <= 0.5) AndAlso (jetList(c).PTFXSmoke = 0) Then
                            jetList(c).PTFXSmoke = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "ambient_steam_vent_oblong", _
                                jetList(c).jet, 0, 0, 0, 0, 0, 0, 2.0)
                        End If

                        If (tmpJetHealthAux < 0.2) AndAlso (jetList(c).PTFXFire = 0) Then
                            jetList(c).PTFXFire = Native.Function.Call(Of Int32)("START_PTFX_ON_VEH", "ambient_fire_generic", _
                                jetList(c).jet, 0, 0, 0, 0, 0, 0, 2.0)
                        End If
                    End If

                    If jetList(c).jet.isOnScreen AndAlso (jetList(c).jet.Position.DistanceTo(myJet.Position) > drawEnemyRectDist) Then
                    '	dim float_temp_1 as double
                    '	dim TO_RADIAN = 0.017453292519943295
                    '	float_temp_1 = Math.Atan2((jetList(c).jet.Position.Y - Player.Character.Position.Y) , (jetList(c).jet.Position.X - Player.Character.Position.X))
                    '	float_temp_1 = float_temp_1 - Game.CurrentCamera.Rotation.Z * TO_RADIAN
                    '	float_temp_1 += 1.570796
                    '	
                    '	dim cam as camera = game.currentcamera
                    '	dim dist as double = jetList(c).jet.position.distanceto(cam.position)
                    '	dim compPos as vector3 = (cam.position + cam.direction * dist)
                    '	dim y as double = (((compPos - jetList(c).jet.position).z)) / dist
                    '	
                    '	if jetList(c).is_hunter then
                    '		GTA.Native.Function.Call("DRAW_RECT", 0.5f + 0.7f * (Math.Sin(float_temp_1)), y + 0.55, 0.01, 0.02, 255, 0, 0, 100)
                    '	elseif jetList(c).is_fugitive then
                    '		GTA.Native.Function.Call("DRAW_RECT", 0.5f + 0.7f * (Math.Sin(float_temp_1)), y + 0.55, 0.01, 0.02, 200, 200, 0, 100)							
                    '	else
                    '		GTA.Native.Function.Call("DRAW_RECT", 0.5f + 0.7f * (Math.Sin(float_temp_1)), y + 0.55, 0.01, 0.02, 100, 100, 100, 100)
                    '	end if

                        'jetList(c).checkPAux.Visible = True
                        'jetList(c).checkPAux.Position = jetList(c).jet.Position
                        'jetList(c).checkPAux.Diameter = jetList(c).jet.Position.DistanceTo(Player.Character.Position) / 60
                        If jetList(c).is_hunter Then
                            Native.Function.Call("DRAW_CHECKPOINT", jetList(c).jet.Position.X, jetList(c).jet.Position.Y, jetList(c).jet.Position.Z, jetList(c).jet.Position.DistanceTo(Player.Character.Position) / 60, 255, 0, 0)
                        Else
                            Native.Function.Call("DRAW_CHECKPOINT", jetList(c).jet.Position.X, jetList(c).jet.Position.Y, jetList(c).jet.Position.Z, jetList(c).jet.Position.DistanceTo(Player.Character.Position) / 60, 255, 255, 0)
                        End If
                    'Else
                        'jetList(c).checkPAux.Visible = False
                    End If
                End If
            Else
                If Exists(jetList(c).jet) Then
                    If jetList(c).jet.Health <= 0 Then
                        If Exists(TJetLocked) AndAlso TJetLocked.Equals(jetList(c)) Then TJetLocked = Nothing

                        If jetEnemyAttacking = jetList(c).jet Then jetEnemyAttacking = Nothing

                        If jetList(c).jet.Position.DistanceTo(myJet.Position) < 500 Then
                            For d As Int16 = 0 To 5
                                Native.Function.Call("break_car_door", jetList(c).jet, d, False)
                            Next

                            explodeEnemyJet(jetList(c))
                        Else
                            Native.Function.Call("stop_ptfx", jetList(c).PTFXSmoke)
                            Native.Function.Call("stop_ptfx", jetList(c).PTFXFire)
                            Native.Function.Call("stop_ptfx", jetList(c).PTFXExp)
                        End If

                        jetList(c).timeRemove = 3000
                    Else
                        If jetList(c).timeRemove <> -1000 Then
                            If (jetList(c).timeRemove <= 0) Then ' if reaches 0, remove
                                removeJet(c)

                                Exit For
                            Else
                                jetList(c).timeRemove -= Me.Interval
                            End If
                        End If
                    End If
                End If
            End If
        Next
    End Sub

    Private Function myJetSpeedAux()
        If myJet.Speed > 40 Then
            Return myJet.Speed
        Else
            Return 40
        End If
    End Function

    ' draw the textures adapting the position, width and height to the user resolution
    Private Sub drawSpriteAux(ByVal e As GTA.GraphicsEventArgs, ByVal tex As Texture, ByVal x As Double, ByVal y As Double, ByVal w As Double, ByVal h As Double, _
       ByVal rot As Double, ByVal col As Color, Optional ByVal square As Boolean = False)
        If square Then
            e.Graphics.DrawSprite(tex, x * width_Coef, y * height_Coef, w * width_Coef, h * width_Coef, rot, col)
        Else
            e.Graphics.DrawSprite(tex, x * width_Coef, y * height_Coef, w * width_Coef, h * height_Coef, rot, col)
        End If
    End Sub

    Private Sub drawLineAux(ByVal e As GTA.GraphicsEventArgs, ByVal xIni As Double, ByVal yIni As Double, ByVal xFin As Double, ByVal yFin As Double, _
       ByVal w As Double, ByVal col As Color)
        e.Graphics.DrawLine(xIni * width_Coef, yIni * height_Coef, xFin * width_Coef, yFin * height_Coef, w * width_Coef, col)
    End Sub

    Private Sub drawTextAux(ByVal e As GTA.GraphicsEventArgs, ByVal text As String, ByVal x As Double, ByVal y As Double, ByVal col As Color)
        e.Graphics.DrawText(text, x * width_Coef, y * height_Coef, col)
    End Sub

    Private Sub GraphicsEventHandler(ByVal sender As Object, ByVal e As GTA.GraphicsEventArgs) Handles MyBase.PerFrameDrawing
        Try
            If bSetupHelpMode Then
                drawTextAux(e, "Jet Setup mode", 20, 20, Color.White)
                drawTextAux(e, "  Controls:", 20, 50, Color.White)
                drawTextAux(e, "   Navigate between itens: Left/Right arrow", 20, 70, Color.White)
                drawTextAux(e, "   Navigate between types: Down arrow", 20, 90, Color.White)
                drawTextAux(e, "   Move up or down: Numpad + or -", 20, 110, Color.White)
                drawTextAux(e, "   Move item left, right, backward or forward: Numpads: 4, 6, 8, 2", 20, 130, Color.White)
                drawTextAux(e, "   Move faster: hold Control", 20, 150, Color.White)
                drawTextAux(e, "   Toggle enabled: Enter", 20, 170, Color.White)
                drawTextAux(e, "   Generate oposite rocket, cannon or engine: G", 20, 190, Color.White)
                drawTextAux(e, "   Toggle free camera: C", 20, 210, Color.White)
                drawTextAux(e, "   Save actual setup: Numpad0", 20, 230, Color.White)

                If SM_type = 0 Then drawTextAux(e, "   Toggle is_bomb: B", 20, 250, Color.White)

                If SM_type = 0 Then
                    drawTextAux(e, "Type: Rocket, item: " & (SM_actual_rocket + 1).ToString & ", enabled: " & myActualJet.MRL(SM_actual_rocket).enabled.ToString & _
                        ", is_bomb: " & myActualJet.MRL(SM_actual_rocket).isBomb.ToString, 20, 290, Color.White)
                    drawTextAux(e, "X offset: " & myActualJet.MRL(SM_actual_rocket).xAttach.ToString, 20, 310, Color.White)
                    drawTextAux(e, "Y offset: " & myActualJet.MRL(SM_actual_rocket).yAttach.ToString, 20, 330, Color.White)
                    drawTextAux(e, "X offset: " & myActualJet.MRL(SM_actual_rocket).zAttach.ToString, 20, 350, Color.White)
                ElseIf SM_type = 1 Then
                    drawTextAux(e, "Type: Cannon, item: " & (SM_actual_cannon + 1).ToString & ", enabled: " & myActualJet.cannList(SM_actual_cannon).enabled.ToString, _
                        20, 290, Color.White)
                    drawTextAux(e, "X offset: " & myActualJet.cannList(SM_actual_cannon).offPosition.X.ToString, 20, 310, Color.White)
                    drawTextAux(e, "Y offset: " & myActualJet.cannList(SM_actual_cannon).offPosition.Y.ToString, 20, 330, Color.White)
                    drawTextAux(e, "Z offset: " & myActualJet.cannList(SM_actual_cannon).offPosition.Z.ToString, 20, 350, Color.White)
                ElseIf SM_type = 2 Then
                    drawTextAux(e, "Type: Engine, item: " & (SM_actual_engine + 1).ToString & ", enabled: " & myActualJet.engineList(SM_actual_engine).enabled.ToString, _
                        20, 290, Color.White)
                    drawTextAux(e, "X offset: " & myActualJet.engineList(SM_actual_engine).offPosition.X.ToString, 20, 310, Color.White)
                    drawTextAux(e, "Y offset: " & myActualJet.engineList(SM_actual_engine).offPosition.Y.ToString, 20, 330, Color.White)
                    drawTextAux(e, "Z offset: " & myActualJet.engineList(SM_actual_engine).offPosition.Z.ToString, 20, 350, Color.White)
                End If

                drawTextAux(e, "Actual jet file: " & myActualJet.fileName, 20, 390, Color.White)

                Exit Sub
            End If

            If bSpawnMenuON Then
                drawTextAux(e, "Jet spawn menu:", 20, 20, Color.White)

                For c As Int16 = 0 To TCustomJetCFGList.Count - 1
                    If c = SM_Current_index Then
                        drawLineAux(e, 20, _
                        70 + c * 20, _
                        500, _
                        70 + c * 20, 2, Color.Red)

                        If Not TCustomJetCFGList(c).texPreview Is Nothing Then drawSpriteAux(e, TCustomJetCFGList(c).texPreview, 650, 220 + c * 20, 387, 200, 0, Color.White)
                    End If

                    drawTextAux(e, TCustomJetCFGList(c).display_name, 20, 50 + c * 20, Color.White)
                Next

                drawTextAux(e, "Controls:", 20, 80 + TCustomJetCFGList.Count * 20, Color.White)
                drawTextAux(e, "   Navigate: " + hkPrevMenuItem.ToString & " and " & hkNextMenuItem.ToString, 20, 105 + TCustomJetCFGList.Count * 20, Color.White)
                drawTextAux(e, "   Spawn: Enter", 20, 130 + TCustomJetCFGList.Count * 20, Color.White)
            End If

            If isInJet() Then
                Dim hPos As Int16 = Math.Round((myHeight / 2) + (myHeight / 500) * Player.Character.Position.Z)
                Dim maxH, minH As Int16
                maxH = 320
                minH = 170
                Dim hPosAux As Int16

                If jetList.Count > 0 Then
                    If jetList.Count < 22 Then
                        drawSpriteAux(e, texBotton, myWidth + Math.Round(myWidth / 4) - (65 * jetList.Count) + 115, 950, 1920, 220, 0, Color.White)
                    Else
                        drawSpriteAux(e, texBotton, myWidth + Math.Round(myWidth / 4) - (65 * 21) + 115, 950, 1920, 220, 0, Color.White)
                    End If
                End If

                drawSpriteAux(e, texBackg, myWidth - 157, 188, 331, 403, 0, Color.White)
                drawTextAux(e, groundZ.ToString, myWidth - 55, 330, Color.FromArgb(175, 0, 255, 150))

                For c As Int16 = -200 To 200
                    hPosAux = hPos + c * 30

                    If (hPosAux < maxH) AndAlso (hPosAux > minH) Then
                        'drawLineAux(e, myWidth - 50, hPosAux, _
                        '	myWidth - 25, hPosAux, 5, color.fromargb(255, 255, 150, 0))
                        drawSpriteAux(e, texLineAux, myWidth - 38, hPosAux, 33, 8, 0, Color.FromArgb(255, 255, 255, 255))
                    End If
                Next

                Dim tmpJetHealthAux As Double

                'tmpJetHealthAux = ((myJet.health + myJet.enginehealth + myJet.petroltankhealth) / 3000)
                tmpJetHealthAux = ((myJet.Health) / 1000)

                If tmpJetHealthAux < 0 Then tmpJetHealthAux = 0

                If rpmAnim >= 360 Then rpmAnim = 0

                rpmAnim += 50 * (myJet.Speed / myActualJet.maxJetSpeed)

                drawSpriteAux(e, texJet, myWidth - 40, 115, 57, 73, 0, Color.FromArgb(255, 255, 255, 255))
                drawSpriteAux(e, texRpm, myWidth - 39, 416, 75, 75, rpmAnim * (3.14 / 180), Color.FromArgb(255, 255, 255, 255), True)

                If Exists(jetEnemyAttacking) OrElse bWarnEnemyMissileLock Then _
                    drawSpriteAux(e, texMissileAlarm, Math.Round(myWidth / 2), 45, 300, 60, 0, Color.FromArgb(255, 255, 255, 255))

                If Exists(TJetLocked) OrElse Exists(heliLocked) OrElse bWarnMyMissileLock Then
                    drawSpriteAux(e, texMissileLocked, Math.Round(myWidth / 2), 85, 300, 60, 0, Color.FromArgb(255, 255, 255, 255))

                    If Exists(TJetLocked) Then drawTargetedHUD(TJetLocked.jet)
                    If Exists(heliLocked) Then drawTargetedHUD(heliLocked)
                End If

                bWarnEnemyMissileLock = False
                bWarnMyMissileLock = False

                If tmpJetHealthAux <= 1 Then
                    drawLineAux(e, myWidth - 20, 155, _
                        myWidth - 20, 155 - Math.Round((75 * tmpJetHealthAux)), _
                        5, Color.FromArgb(200, 255, 255 * tmpJetHealthAux, 0))
                End If

                For Each m As MR In myActualJet.MRL
                    If Not m.enabled Then Continue For

                    If Not m.launched Then
                        If Not m.isBomb Then
                            drawSpriteAux(e, texMissile, myWidth - 20 * myActualJet.MRL.IndexOf(m) - 15, 35, 15, 58, 0, Color.FromArgb(255, 255, 255, 255))
                        Else
                            drawSpriteAux(e, texBomb, myWidth - 30 * myActualJet.MRL.IndexOf(m) - 15, 35, 30, 58, 0, Color.FromArgb(255, 255, 255, 255))
                        End If
                    Else
                        If Not m.isBomb Then
                            drawSpriteAux(e, texMissile, myWidth - 20 * myActualJet.MRL.IndexOf(m) - 15, 35, 15, 58, 0, Color.FromArgb(255, 100, 100, 100))
                        Else
                            drawSpriteAux(e, texBomb, myWidth - 30 * myActualJet.MRL.IndexOf(m) - 15, 35, 30, 58, 0, Color.FromArgb(255, 100, 100, 100))
                        End If
                    End If
                Next

                ' flare indicator
                If (timeShowFlareAux <= 0) AndAlso (timeOutMyFlare > 0) Then
                    timeShowFlareAux = 50
                    drawSpriteAux(e, texFlares, myWidth - 270, 15, 35, 35, 0, Color.FromArgb(255, 255 - (255 * (timeOutMyFlare / 3000)), 255 - (255 * (timeOutMyFlare / 3000)), 255 - (255 * (timeOutMyFlare / 3000))))
                ElseIf timeOutMyFlare <= 0 Then
                    drawSpriteAux(e, texFlares, myWidth - 270, 15, 35, 35, 0, Color.FromArgb(255, 255, 255, 255))
                End If

                For c As Int16 = jetList.Count - 1 To 0 Step -1
                    If Exists(jetList(c).jet) AndAlso Exists(jetList(c).p) Then
                        If (c < 21) AndAlso (jetList(c).timeRemove = -1000) AndAlso Exists(jetList(c).p) Then
                            'tmpJetHealthAux = ((jetList(c).jet.health + jetList(c).jet.enginehealth + jetList(c).jet.petroltankhealth) / 3000)					
                            tmpJetHealthAux = ((jetList(c).jet.Health) / 1000)

                            If tmpJetHealthAux < 0 Then tmpJetHealthAux = 0

                            If jetList(c).is_hunter Then
                                drawSpriteAux(e, texJet, myWidth - 65 * c - 35, myHeight - 85, 57, 73, 0, Color.FromArgb(100, 255, 0, 0))
                            Else
                                drawSpriteAux(e, texJet, myWidth - 65 * c - 35, myHeight - 85, 57, 73, 0, Color.FromArgb(100, 200, 200, 0))
                            End If

                            If tmpJetHealthAux <= 1 Then
                                drawLineAux(e, myWidth - 65 * c - 10, myHeight - 45, _
                                    myWidth - 65 * c - 10, myHeight - Math.Round(45 + (75 * tmpJetHealthAux)), _
                                    5, Color.FromArgb(200, 255, 255 * tmpJetHealthAux, 0))
                            End If

                            If jetList(c).jet = jetEnemyAttacking Then
                                drawTextAux(e, "Missile", myWidth - 65 * c - 75, myHeight - 110, Color.FromArgb(175, 0, 255, 150))
                                drawTextAux(e, "locked", myWidth - 65 * c - 75, myHeight - 85, Color.FromArgb(175, 0, 255, 150))
                            End If
                        End If
                    End If
                Next

                If jetList.Count > 21 Then drawTextAux(e, "+", 300, myHeight - 100, Color.FromArgb(175, 0, 255, 150))

                If bFlapsHelpMode Then
                    drawTextAux(e, "*** Flaps helper ***", 10, 10, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, "Hold the number of the Door ID to see what flap/gear/wing it is...", 10, 35, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, " then use this number in the .INI file in the wings_flaps section", 10, 60, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, "Numpad 0 - Left front door", 10, 100, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, "Numpad 1 - Right front door", 10, 125, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, "Numpad 2 - Left rear door", 10, 150, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, "Numpad 3 - Right rear door", 10, 175, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, "Numpad 4 - Hood", 10, 200, Color.FromArgb(255, 255, 255, 255))
                    drawTextAux(e, "Numpad 5 - Trunk", 10, 225, Color.FromArgb(255, 255, 255, 255))
                End If
            End If
        Catch
        End Try
    End Sub

    Private Sub removeJet(ByVal pos As Int16)
        Try
            If jetList(pos).jet = jetEnemyAttacking Then jetEnemyAttacking = Nothing

            Native.Function.Call("stop_ptfx", jetList(pos).PTFXSmoke)
            Native.Function.Call("stop_ptfx", jetList(pos).PTFXFire)
            Native.Function.Call("stop_ptfx", jetList(pos).PTFXExp)

            jetList(pos).jetblip.Delete()
            jetList(pos).timeRemove = -1000

            If Not jetList(pos).isMP AndAlso Exists(jetList(pos).jet) Then jetList(pos).jet.NoLongerNeeded()
            If Not jetList(pos).isMP AndAlso Exists(jetList(pos).p) Then jetList(pos).p.NoLongerNeeded()

            'wreckedJetList.add(jetList(pos))

            'jetList(pos).checkPAux.Visible = False
            jetList.RemoveAt(pos)
        Catch
        End Try
    End Sub

    Private Function rotateVec(ByVal vec As Vector3, ByVal angle As Double)
        angle = angle * (3.1415 / 180)

        Dim s As Double = System.Math.Sin(angle)
        Dim c As Double = System.Math.Cos(angle)

        vec.X = vec.X * c - vec.Y * s
        vec.Y = vec.X * s + vec.Y * c

        Return vec
    End Function

    Private Sub console_CMD(ByVal sender As Object, ByVal e As ConsoleEventArgs) Handles MyBase.ConsoleCommand
        If e.Command = "anyjet" Then
            If e.ParameterCount > 0 Then
                If (e.Parameter(0) = "flaps") Then
                    bSetupHelpMode = False
                    bSpawnMenuON = False
                    bShowPosition = False

                    bFlapsHelpMode = Not bFlapsHelpMode

                    If bFlapsHelpMode AndAlso Not isInJet() Then
                        msg("enter in an jet and repeat the command...", 3000)
                        bFlapsHelpMode = False
                    End If
                ElseIf (e.Parameter(0) = "pos") Then
                    bSpawnMenuON = False
                    bSetupHelpMode = False
                    bFlapsHelpMode = False

                    bShowPosition = Not bShowPosition
                ElseIf (e.Parameter(0) = "setup") Then
                    bSpawnMenuON = False
                    bShowPosition = False
                    bFlapsHelpMode = False

                    bSetupHelpMode = Not bSetupHelpMode

                    If bSetupHelpMode AndAlso Not Exists(myJet) Then
                        bSetupHelpMode = False
                        msg("Enter in a jet and repeat the command...", 3000)
                        Exit Sub
                    End If

                    If bSetupHelpMode Then
                        msg("Setup mode ON...", 5000)
                        myJet.FreezePosition = True
                        myJet.Position = myJet.Position.ToGround + Vector3.WorldUp * 300

                        For Each m As MR In myActualJet.MRL
                            m.rocket.Visible = False
                            Native.Function.Call("stop_ptfx", m.ptfxID)

                            If myActualJet.MRL.IndexOf(m) = SM_actual_rocket Then
                                m.attach(myJet)
                                m.ptfxID = Native.Function.Call(Of Int32)("START_PTFX_ON_OBJ", "weap_rocket_player", m.rocket, 0, 0, 0, 0, 0, 0, 1.0)
                                m.rocket.Visible = True
                            End If
                        Next
                    Else
                        msg("Setup mode OFF...", 5000)
                        myJet.FreezePosition = False
                    End If
                Else
                    For Each j As TCustomJetCFG In TCustomJetCFGList
                        If j.console_cmd_spawn = e.Parameter(0) Then
                            spawnMyJet(j)
                            Exit For
                        End If
                    Next
                End If
            End If
        End If
    End Sub

    Private Sub sndCannonPlay()
        Dim vecPos As Vector3

        If camMode = 0 Then
            vecPos = Player.Character.Position + Game.CurrentCamera.Direction * 15
        ElseIf camMode = 4 Then
            vecPos = Player.Character.Position - planeDir() * 30
        Else
            vecPos = Player.Character.Position + planeDir() * 10
        End If

        Native.Function.Call("stop_sound", IDsndCannon)
        'native.function.call("PLAY_SOUND_FROM_position", IDsndCannon, soundCannon, player.character)
        Native.Function.Call("PLAY_SOUND_FROM_position", IDsndCannon, myActualJet.soundCannon, vecPos.X, vecPos.Y, vecPos.Z)
    End Sub

    Private Sub clearHeliList()
        For Each h As THeli In heliList
            Try
                h.heli.Metadata.isAnHeli = False

                For Each p As Ped In World.GetPeds(h.heli.Position, 15.0)
                    If Exists(p) AndAlso (p.CurrentVehicle = h.heli) Then
                        If Not Exists(p.GetControllingPlayer) Then p.NoLongerNeeded()
                    End If
                Next

                h.heli.isRequiredForMission = False
                h.heli.NoLongerNeeded()
            Catch
            End Try
        Next

        heliList.Clear()
    End Sub

    Private Sub saveNewSetup()
        msg("Saving...", 30000)

        iniFile = ".\Scripts\JetFiles\Jets\" & myActualJet.fileName
        checkIniExists()

        Try
            For c As Int16 = 1 To myActualJet.MRL.Count
                If myActualJet.MRL(c - 1).enabled Then WriteINI("enabled", "rocket_" & c.ToString, "1") Else WriteINI("enabled", "rocket_" & c.ToString, "0")
                If myActualJet.MRL(c - 1).isBomb Then WriteINI("is_bomb", "rocket_" & c.ToString, "1") Else WriteINI("is_bomb", "rocket_" & c.ToString, "0")
                WriteINI("x", "rocket_" & c.ToString, myActualJet.MRL(c - 1).xAttach.ToString)
                WriteINI("y", "rocket_" & c.ToString, myActualJet.MRL(c - 1).yAttach.ToString)
                WriteINI("z", "rocket_" & c.ToString, myActualJet.MRL(c - 1).zAttach.ToString)
            Next
            For c As Int16 = 1 To myActualJet.cannList.Count
                If myActualJet.cannList(c - 1).enabled Then WriteINI("enabled", "cannon_" & c.ToString, "1") Else WriteINI("enabled", "cannon_" & c.ToString, "0")
                WriteINI("x", "cannon_" & c.ToString, myActualJet.cannList(c - 1).offPosition.X.ToString)
                WriteINI("y", "cannon_" & c.ToString, myActualJet.cannList(c - 1).offPosition.Y.ToString)
                WriteINI("z", "cannon_" & c.ToString, myActualJet.cannList(c - 1).offPosition.Z.ToString)
            Next
            For c As Int16 = 1 To myActualJet.engineList.Count
                If myActualJet.engineList(c - 1).enabled Then WriteINI("enabled", "engine_" & c.ToString, "1") Else WriteINI("enabled", "engine_" & c.ToString, "0")
                WriteINI("x", "engine_" & c.ToString, myActualJet.engineList(c - 1).offPosition.X.ToString)
                WriteINI("y", "engine_" & c.ToString, myActualJet.engineList(c - 1).offPosition.Y.ToString)
                WriteINI("z", "engine_" & c.ToString, myActualJet.engineList(c - 1).offPosition.Z.ToString)
            Next

            msg("Saved!", 3000)
        Catch ex As Exception
            msg("Error: " & ex.Message, 60000)
        End Try
    End Sub

    Private Sub loadConfig()
        ' hotkeys
        If Settings.GetValueKey("hkShootRocket", "general", -1) = -1 Then Settings.SetValue("hkShootRocket", "general", Keys.Space)
        If Settings.GetValueKey("hkShootCannon", "general", -1) = -1 Then Settings.SetValue("hkShootCannon", "general", Keys.NumPad0)
        If Settings.GetValueKey("hkDropBomb", "general", -1) = -1 Then Settings.SetValue("hkDropBomb", "general", Keys.Q)
        If Settings.GetValueKey("hkSwitchGun", "general", -1) = -1 Then Settings.SetValue("hkSwitchGun", "general", Keys.RButton)
        If Settings.GetValueKey("hkSpawnEnemy", "general", -1) = -1 Then Settings.SetValue("hkSpawnEnemy", "general", Keys.D2)
        If Settings.GetValueKey("hkSpawnFugitive", "general", -1) = -1 Then Settings.SetValue("hkSpawnFugitive", "general", Keys.D3)
        If Settings.GetValueKey("hkJetMoveDown", "general", -1) = -1 Then Settings.SetValue("hkJetMoveDown", "general", Keys.ShiftKey)
        If Settings.GetValueKey("hkJetMoveUp", "general", -1) = -1 Then Settings.SetValue("hkJetMoveUp", "general", Keys.ControlKey)
        If Settings.GetValueKey("hkEject", "general", -1) = -1 Then Settings.SetValue("hkEject", "general", Keys.F)
        If Settings.GetValueKey("hkEnterJet", "general", -1) = -1 Then Settings.SetValue("hkEnterJet", "general", Keys.F)
        If Settings.GetValueKey("hkSwitchCam", "general", -1) = -1 Then Settings.SetValue("hkSwitchCam", "general", Keys.X)
        If Settings.GetValueKey("hkFlare", "general", -1) = -1 Then Settings.SetValue("hkFlare", "general", Keys.E)
        If Settings.GetValueKey("hkTurnLeft", "general", -1) = -1 Then Settings.SetValue("hkTurnLeft", "general", Keys.NumPad7)
        If Settings.GetValueKey("hkTurnRight", "general", -1) = -1 Then Settings.SetValue("hkTurnRight", "general", Keys.NumPad9)
        If Settings.GetValueKey("hkRollLeft", "general", -1) = -1 Then Settings.SetValue("hkRollLeft", "general", Keys.NumPad4)
        If Settings.GetValueKey("hkRollRight", "general", -1) = -1 Then Settings.SetValue("hkRollRight", "general", Keys.NumPad6)
        If Settings.GetValueKey("hkUp", "general", -1) = -1 Then Settings.SetValue("hkUp", "general", Keys.NumPad5)
        If Settings.GetValueKey("hkDown", "general", -1) = -1 Then Settings.SetValue("hkDown", "general", Keys.NumPad8)
        If Settings.GetValueKey("hkSpawnMenu", "general", -1) = -1 Then Settings.SetValue("hkSpawnMenu", "general", Keys.D0)
        If Settings.GetValueKey("hkNextMenuItem", "general", -1) = -1 Then Settings.SetValue("hkNextMenuItem", "general", Keys.Right)
        If Settings.GetValueKey("hkPrevMenuItem", "general", -1) = -1 Then Settings.SetValue("hkPrevMenuItem", "general", Keys.Left)
        If Settings.GetValueKey("myGameWidth", "general", -1) = -1 Then Settings.SetValue("myGameWidth", "general", Game.Resolution.Width)
        If Settings.GetValueKey("myGameHeight", "general", -1) = -1 Then Settings.SetValue("myGameHeight", "general", Game.Resolution.Height)
        If Settings.GetValueFloat("AimEase", "general", -1) = -1 Then Settings.SetValue("AimEase", "general", "1.0")

        If Settings.GetValueString("camPilotHidePlayer", "extra_cams", "-100") = "-100" Then Settings.SetValue("camPilotHidePlayer", "extra_cams", "0")
        If Settings.GetValueString("camPilotFixedRotation", "extra_cams", "-100") = "-100" Then Settings.SetValue("camPilotFixedRotation", "extra_cams", "0")

        camPilotHidePlayer = Settings.GetValueString("camPilotHidePlayer", "extra_cams", "-100") = "1"
        camPilotFixedRotation = Settings.GetValueString("camPilotFixedRotation", "extra_cams", "-100") = "1"

        ' space trip
        If Settings.GetValueFloat("st_height_teleport", "space_trip", 0) = 0 Then Settings.SetValue("st_height_teleport", "space_trip", "4000.0")
        If Settings.GetValueFloat("st_height_teleport_back", "space_trip", 0) = 0 Then Settings.SetValue("st_height_teleport_back", "space_trip", "19700.0")
        If Settings.GetValueFloat("st_teleport_pos_x", "space_trip", 0) = 0 Then Settings.SetValue("st_teleport_pos_x", "space_trip", "400")
        If Settings.GetValueFloat("st_teleport_pos_y", "space_trip", 0) = 0 Then Settings.SetValue("st_teleport_pos_y", "space_trip", "220")
        If Settings.GetValueFloat("st_teleport_pos_z", "space_trip", 0) = 0 Then Settings.SetValue("st_teleport_pos_z", "space_trip", "20000")
        If Settings.GetValueFloat("st_teleport_pos_back_x", "space_trip", 0) = 0 Then Settings.SetValue("st_teleport_pos_back_x", "space_trip", "400")
        If Settings.GetValueFloat("st_teleport_pos_back_y", "space_trip", 0) = 0 Then Settings.SetValue("st_teleport_pos_back_y", "space_trip", "220")
        If Settings.GetValueFloat("st_teleport_pos_back_z", "space_trip", 0) = 0 Then Settings.SetValue("st_teleport_pos_back_z", "space_trip", "3000")
        If Settings.GetValueFloat("st_time_check", "space_trip", 0) = 0 Then Settings.SetValue("st_time_check", "space_trip", "1000.0")

        ' enemy cfg
        If Settings.GetValueKey("enemyJet_shoot_cannon", "enemy_cfg", -1) = -1 Then Settings.SetValue("enemyJet_shoot_cannon", "enemy_cfg", 1)
        If Settings.GetValueKey("enemyJet_shoot_rocket", "enemy_cfg", -1) = -1 Then Settings.SetValue("enemyJet_shoot_rocket", "enemy_cfg", 1)
        If Settings.GetValueKey("enemyJet_cannon_dmg", "enemy_cfg", -1) = -1 Then Settings.SetValue("enemyJet_cannon_dmg", "enemy_cfg", 15)
        If Settings.GetValueKey("enemyJet_rocket_damage", "enemy_cfg", -1) = -1 Then Settings.SetValue("enemyJet_rocket_damage", "enemy_cfg", 300)
        If Settings.GetValueKey("enemyJet_rocket_timewait", "enemy_cfg", -1) = -1 Then Settings.SetValue("enemyJet_rocket_timewait", "enemy_cfg", 2000)
        If Settings.GetValueKey("maxRoundForEvade", "enemy_cfg", -1) = -1 Then Settings.SetValue("maxRoundForEvade", "enemy_cfg", 200)
        If Settings.GetValueKey("maxRoundForFugitiveEvade", "enemy_cfg", -1) = -1 Then Settings.SetValue("maxRoundForFugitiveEvade", "enemy_cfg", 300)
        If Settings.GetValueKey("drawEnemyRectDist", "enemy_cfg", -1) = -1 Then Settings.SetValue("drawEnemyRectDist", "enemy_cfg", 350)

        hkShootRocket = Settings.GetValueKey("hkShootRocket", "general", -1)
        hkShootCannon = Settings.GetValueKey("hkShootCannon", "general", -1)
        hkDropBomb = Settings.GetValueKey("hkDropBomb", "general", -1)
        hkSwitchGun = Settings.GetValueKey("hkSwitchGun", "general", -1)
        hkSpawnEnemy = Settings.GetValueKey("hkSpawnEnemy", "general", -1)
        hkSpawnFugitive = Settings.GetValueKey("hkSpawnFugitive", "general", -1)
        hkJetMoveDown = Settings.GetValueKey("hkJetMoveDown", "general", -1)
        hkJetMoveUp = Settings.GetValueKey("hkJetMoveUp", "general", -1)
        hkEject = Settings.GetValueKey("hkEject", "general", -1)
        hkEnterJet = Settings.GetValueKey("hkEnterJet", "general", -1)
        hkSwitchCam = Settings.GetValueKey("hkSwitchCam", "general", -1)
        hkFlare = Settings.GetValueKey("hkFlare", "general", -1)
        hkTurnLeft = Settings.GetValueKey("hkTurnLeft", "general", -1)
        hkTurnRight = Settings.GetValueKey("hkTurnRight", "general", -1)
        hkRollLeft = Settings.GetValueKey("hkRollLeft", "general", -1)
        hkRollRight = Settings.GetValueKey("hkRollRight", "general", -1)
        hkUp = Settings.GetValueKey("hkUp", "general", -1)
        hkDown = Settings.GetValueKey("hkDown", "general", -1)
        hkSpawnMenu = Settings.GetValueKey("hkSpawnMenu", "general", -1)
        hkNextMenuItem = Settings.GetValueKey("hkNextMenuItem", "general", -1)
        hkPrevMenuItem = Settings.GetValueKey("hkPrevMenuItem", "general", -1)

        myGameWidth = Settings.GetValueInteger("myGameWidth", "general", -1)
        myGameHeight = Settings.GetValueInteger("myGameHeight", "general", -1)

        width_Coef = myGameWidth / myWidth
        height_Coef = myGameHeight / myHeight

        AimEase = Settings.GetValueFloat("AimEase", "general", -1)

        enemyJet_shoot_cannon = Settings.GetValueKey("enemyJet_shoot_cannon", "enemy_cfg", -1) = 1
        enemyJet_shoot_rocket = Settings.GetValueKey("enemyJet_shoot_rocket", "enemy_cfg", -1) = 1
        enemyJet_cannon_dmg = Settings.GetValueKey("enemyJet_cannon_dmg", "enemy_cfg", -1)
        enemyJet_rocket_damage = Settings.GetValueKey("enemyJet_rocket_damage", "enemy_cfg", -1)
        enemyJet_rocket_timewait = Settings.GetValueKey("enemyJet_rocket_timewait", "enemy_cfg", -1)
        maxRoundForEvade = Settings.GetValueKey("maxRoundForEvade", "enemy_cfg", -1)
        maxRoundForFugitiveEvade = Settings.GetValueKey("maxRoundForFugitiveEvade", "enemy_cfg", -1)
        drawEnemyRectDist = Settings.GetValueKey("drawEnemyRectDist", "enemy_cfg", -1)

        ' space trip
        st_height_teleport = Settings.GetValueFloat("st_height_teleport", "space_trip", 0)
        st_height_teleport_back = Settings.GetValueFloat("st_height_teleport_back", "space_trip", 0)
        st_teleport_pos.X = Settings.GetValueFloat("st_teleport_pos_x", "space_trip", 0)
        st_teleport_pos.Y = Settings.GetValueFloat("st_teleport_pos_y", "space_trip", 0)
        st_teleport_pos.Z = Settings.GetValueFloat("st_teleport_pos_z", "space_trip", 0)
        st_teleport_pos_back.X = Settings.GetValueFloat("st_teleport_pos_back_x", "space_trip", 0)
        st_teleport_pos_back.Y = Settings.GetValueFloat("st_teleport_pos_back_y", "space_trip", 0)
        st_teleport_pos_back.Z = Settings.GetValueFloat("st_teleport_pos_back_z", "space_trip", 0)
        st_time_check = Settings.GetValueFloat("st_time_check", "space_trip", 0) = 0

        Settings.Save()
    End Sub

    Private Sub loadJetConfig()
        myRockets.Clear()

        Dim tmpObj As GTA.Object = Nothing

        For c As Int16 = 0 To 16
            tmpObj = World.CreateObject("cj_rpg_rocket", Player.Character.Position.Around(5) + Vector3.WorldUp * 100)

            Wait(20)

            If Not Exists(tmpObj) Then tmpObj = World.CreateObject("cj_rpg_rocket", Player.Character.Position.Around(5) + Vector3.WorldUp * 100)

            tmpObj.Visible = False

            myRockets.Add(tmpObj)
        Next

        Dim dirInfo As New IO.DirectoryInfo(".\Scripts\JetFiles\Jets\")
        Dim fileList As IO.FileInfo() = dirInfo.GetFiles("jet_*.ini")
        Dim f As IO.FileInfo

        For Each f In fileList
            If f.Name.Substring(0, 4) = "jet_" Then
                iniFile = f.FullName
                checkIniExists()

                Wait(50)

                tmpTCustomJetCFG = New TCustomJetCFG

                tmpTCustomJetCFG.fileName = f.Name

                If ReadINI("preview_img", "general", "-1") = "-1" Then WriteINI("preview_img", "general", "")

                Try
                    If (ReadINI("preview_img", "general", "-1") <> "") AndAlso File.Exists(f.Directory.FullName & "\" & ReadINI("preview_img", "general", "-1")) Then _
                        tmpTCustomJetCFG.texPreview = New Texture(File.ReadAllBytes(f.Directory.FullName & "\" & ReadINI("preview_img", "general", "-1")))
                Catch
                    tmpTCustomJetCFG.texPreview = Nothing
                End Try

                ' custom jet cfg
                If ReadINI("display_name", "general", "-1") = "-1" Then WriteINI("display_name", "general", "")
                'if ReadINI("hotKeySpawn", "general", "-1") = "-1" then WriteINI("hotKeySpawn", "general", "0")
                If ReadINI("console_cmd_spawn", "general", "-1") = "-1" Then WriteINI("console_cmd_spawn", "general", "")
                If ReadINI("jet_model", "general", "") = "" Then WriteINI("jet_model", "general", "airtug")
                If ReadINI("pilot_model", "general", "-1") = "-1" Then WriteINI("pilot_model", "general", "")
                If ReadINI("enemy_model", "general", "-1") = "-1" Then WriteINI("enemy_model", "general", "")
                If ReadINI("maxJetSpeed", "general", "0") = "0" Then WriteINI("maxJetSpeed", "general", "400.0")
                If ReadINI("use_fake_jet", "general", "-1") = "-1" Then WriteINI("use_fake_jet", "general", "0")

                tmpTCustomJetCFG.display_name = ReadINI("display_name", "general", "")
                'tmpTCustomJetCFG.hotKeySpawn = Helper.StringToKey(ReadINI("hotKeySpawn", "general", "0"), Keys.VolumeUp)
                tmpTCustomJetCFG.console_cmd_spawn = ReadINI("console_cmd_spawn", "general", "")
                tmpTCustomJetCFG.jetModel = New Model(ReadINI("jet_model", "general", "-1"))

                If ReadINI("pilot_model", "general", "-1") <> "" Then
                    tmpTCustomJetCFG.pilot_model = New Model(ReadINI("pilot_model", "general", "-1"))
                Else
                    tmpTCustomJetCFG.pilot_model = Nothing
                End If

                tmpTCustomJetCFG.sEnemy_model = ReadINI("enemy_model", "general", "-1")
                If tmpTCustomJetCFG.sEnemy_model <> "" Then
                    tmpTCustomJetCFG.enemy_model = New Model(tmpTCustomJetCFG.sEnemy_model)
                Else
                    tmpTCustomJetCFG.enemy_model = Nothing
                End If

                tmpTCustomJetCFG.maxJetSpeed = Double.Parse(ReadINI("maxJetSpeed", "general", "-1"))
                tmpTCustomJetCFG.use_fake_jet = ReadINI("use_fake_jet", "general", "-1") = "1"

                ' move/roll force		
                'moveLeftForce, moveRightForce, rollLeftForce, rollRightForce, moveUpForce, moveDownForce
                If ReadINI("moveLeftForce", "general", "-1") = "-1" Then WriteINI("moveLeftForce", "general", "1")
                If ReadINI("moveRightForce", "general", "-1") = "-1" Then WriteINI("moveRightForce", "general", "1")
                If ReadINI("rollLeftForce", "general", "-1") = "-1" Then WriteINI("rollLeftForce", "general", "1")
                If ReadINI("rollRightForce", "general", "-1") = "-1" Then WriteINI("rollRightForce", "general", "1")
                If ReadINI("moveUpForce", "general", "-1") = "-1" Then WriteINI("moveUpForce", "general", "1")
                If ReadINI("moveDownForce", "general", "-1") = "-1" Then WriteINI("moveDownForce", "general", "1")

                tmpTCustomJetCFG.moveLeftForce = Double.Parse(ReadINI("moveLeftForce", "general", "-1"))
                tmpTCustomJetCFG.moveRightForce = Double.Parse(ReadINI("moveRightForce", "general", "-1"))
                tmpTCustomJetCFG.rollLeftForce = Double.Parse(ReadINI("rollLeftForce", "general", "-1"))
                tmpTCustomJetCFG.rollRightForce = Double.Parse(ReadINI("rollRightForce", "general", "-1"))
                tmpTCustomJetCFG.moveUpForce = Double.Parse(ReadINI("moveUpForce", "general", "-1"))
                tmpTCustomJetCFG.moveDownForce = Double.Parse(ReadINI("moveDownForce", "general", "-1"))

                writeDiv("general")

                'engines		
                If ReadINI("minFxSize", "engineFX", "-100") = "-100" Then WriteINI("minFxSize", "engineFX", "0.1")
                If ReadINI("idleFxSize", "engineFX", "-100") = "-100" Then WriteINI("idleFxSize", "engineFX", "1.5")
                If ReadINI("maxFxSize", "engineFX", "-100") = "-100" Then WriteINI("maxFxSize", "engineFX", "3.0")

                tmpTCustomJetCFG.engineMinFxSize = Double.Parse(ReadINI("minFxSize", "engineFX", "-100"))
                tmpTCustomJetCFG.engineIdleFxSize = Double.Parse(ReadINI("idleFxSize", "engineFX", "-100"))
                tmpTCustomJetCFG.engineMaxFxSize = Double.Parse(ReadINI("maxFxSize", "engineFX", "-100"))

                writeDiv("engineFX")

                For c As Int16 = 1 To 4
                    If ReadINI("enabled", "engine_" & c.ToString, "-100") = "-100" Then WriteINI("enabled", "engine_" & c.ToString, "0")
                    If ReadINI("x", "engine_" & c.ToString, "-100") = "-100" Then WriteINI("x", "engine_" & c.ToString, "0")
                    If ReadINI("y", "engine_" & c.ToString, "-100") = "-100" Then WriteINI("y", "engine_" & c.ToString, "-9.0")
                    If ReadINI("z", "engine_" & c.ToString, "-100") = "-100" Then WriteINI("z", "engine_" & c.ToString, "-0.1")
                    'if ReadINI("enabled", "engine_" & c.tostring, "-100") = "1" then
                        tmpEngine = New engine
                        tmpEngine.enabled = ReadINI("enabled", "engine_" & c.ToString, "-100") = "1"
                        tmpEngine.offPosition.X = Double.Parse(ReadINI("x", "engine_" & c.ToString, "-100"))
                        tmpEngine.offPosition.Y = Double.Parse(ReadINI("y", "engine_" & c.ToString, "-100"))
                        tmpEngine.offPosition.Z = Double.Parse(ReadINI("z", "engine_" & c.ToString, "-100"))
                        tmpTCustomJetCFG.engineList.Add(tmpEngine)
                    'end if

                    If c = 4 Then writeDiv("engine_" & c.ToString)
                Next

                ' extra cams
                If Double.Parse(ReadINI("cam1_ahead_Offset", "extra_cams", "-100")) = "-100" Then WriteINI("cam1_ahead_Offset", "extra_cams", "2.0")
                If Double.Parse(ReadINI("cam1_up_offset", "extra_cams", "-100")) = "-100" Then WriteINI("cam1_up_offset", "extra_cams", "1.4")
                If Double.Parse(ReadINI("cam2_ahead_Offset", "extra_cams", "-100")) = "-100" Then WriteINI("cam2_ahead_Offset", "extra_cams", "2.0")
                If Double.Parse(ReadINI("cam2_up_offset", "extra_cams", "-100")) = "-100" Then WriteINI("cam2_up_offset", "extra_cams", "1.5")
                If Double.Parse(ReadINI("cam3_ahead_Offset", "extra_cams", "-100")) = "-100" Then WriteINI("cam3_ahead_Offset", "extra_cams", "14.0")
                If Double.Parse(ReadINI("cam3_up_offset", "extra_cams", "-100")) = "-100" Then WriteINI("cam3_up_offset", "extra_cams", "2.5")

                tmpTCustomJetCFG.cam1_ahead_Offset = Double.Parse(ReadINI("cam1_ahead_Offset", "extra_cams", "-100"))
                tmpTCustomJetCFG.cam1_up_offset = Double.Parse(ReadINI("cam1_up_offset", "extra_cams", "-100"))
                tmpTCustomJetCFG.cam2_ahead_Offset = Double.Parse(ReadINI("cam2_ahead_Offset", "extra_cams", "-100"))
                tmpTCustomJetCFG.cam2_up_offset = Double.Parse(ReadINI("cam2_up_offset", "extra_cams", "-100"))
                tmpTCustomJetCFG.cam3_ahead_Offset = Double.Parse(ReadINI("cam3_ahead_Offset", "extra_cams", "-100"))
                tmpTCustomJetCFG.cam3_up_offset = Double.Parse(ReadINI("cam3_up_offset", "extra_cams", "-100"))

                writeDiv("extra_cams")

                ' wings/flaps
                If ReadINI("maxWingAngle", "wing_flaps", "-100") = "-100" Then WriteINI("maxWingAngle", "wing_flaps", "0")
                If ReadINI("cockpit_id", "wing_flaps", "-100") = "-100" Then WriteINI("cockpit_id", "wing_flaps", "-1")
                If ReadINI("left_wing_id", "wing_flaps", "-100") = "-100" Then WriteINI("left_wing_id", "wing_flaps", "-1")
                If ReadINI("right_wing_id", "wing_flaps", "-100") = "-100" Then WriteINI("right_wing_id", "wing_flaps", "-1")
                If ReadINI("left_flap_id", "wing_flaps", "-100") = "-100" Then WriteINI("left_flap_id", "wing_flaps", "-1")
                If ReadINI("right_flap_id", "wing_flaps", "-100") = "-100" Then WriteINI("right_flap_id", "wing_flaps", "-1")
                If ReadINI("back_gears_r_id", "wing_flaps", "-100") = "-100" Then WriteINI("back_gears_r_id", "wing_flaps", "-1")
                If ReadINI("back_gears_l_id", "wing_flaps", "-100") = "-100" Then WriteINI("back_gears_l_id", "wing_flaps", "-1")
                If ReadINI("front_gears_r_id", "wing_flaps", "-100") = "-100" Then WriteINI("front_gears_r_id", "wing_flaps", "-1")
                If ReadINI("front_gears_l_id", "wing_flaps", "-100") = "-100" Then WriteINI("front_gears_l_id", "wing_flaps", "-1")
                If ReadINI("rudder_1_id", "wing_flaps", "-100") = "-100" Then WriteINI("rudder_1_id", "wing_flaps", "-1")
                If ReadINI("rudder_2_id", "wing_flaps", "-100") = "-100" Then WriteINI("rudder_2_id", "wing_flaps", "-1")
                If ReadINI("elevator_1_id", "wing_flaps", "-100") = "-100" Then WriteINI("elevator_1_id", "wing_flaps", "-1")
                If ReadINI("elevator_2_id", "wing_flaps", "-100") = "-100" Then WriteINI("elevator_2_id", "wing_flaps", "-1")

                If ReadINI("idleFlapsAngle", "wing_flaps", "-100") = "-100" Then WriteINI("idleFlapsAngle", "wing_flaps", "0")
                If ReadINI("minFlapsAngle", "wing_flaps", "-100") = "-100" Then WriteINI("minFlapsAngle", "wing_flaps", "0")
                If ReadINI("maxFlapsAngle", "wing_flaps", "-100") = "-100" Then WriteINI("maxFlapsAngle", "wing_flaps", "0")
                If ReadINI("gears_closed_angle", "wing_flaps", "-100") = "-100" Then WriteINI("gears_closed_angle", "wing_flaps", "-100")
                If ReadINI("gears_open_angle", "wing_flaps", "-100") = "-100" Then WriteINI("gears_open_angle", "wing_flaps", "-100")
                If ReadINI("rudder_idle_angle", "wing_flaps", "-100") = "-100" Then WriteINI("rudder_idle_angle", "wing_flaps", "-100")
                If ReadINI("rudder_min_angle", "wing_flaps", "-100") = "-100" Then WriteINI("rudder_min_angle", "wing_flaps", "-100")
                If ReadINI("rudder_max_angle", "wing_flaps", "-100") = "-100" Then WriteINI("rudder_max_angle", "wing_flaps", "-100")
                If ReadINI("elevator_max_angle", "wing_flaps", "-100") = "-100" Then WriteINI("elevator_max_angle", "wing_flaps", "-100")
                If ReadINI("elevator_min_angle", "wing_flaps", "-100") = "-100" Then WriteINI("elevator_min_angle", "wing_flaps", "-100")
                If ReadINI("elevator_idle_angle", "wing_flaps", "-100") = "-100" Then WriteINI("elevator_idle_angle", "wing_flaps", "-100")

                tmpTCustomJetCFG.maxWingAngle = Double.Parse(ReadINI("maxWingAngle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.idleFlapsAngle = Double.Parse(ReadINI("idleFlapsAngle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.minFlapsAngle = Double.Parse(ReadINI("minFlapsAngle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.maxFlapsAngle = Double.Parse(ReadINI("maxFlapsAngle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.cockpit_id = Int32.Parse(ReadINI("cockpit_id", "wing_flaps", "-1"))
                tmpTCustomJetCFG.left_wing_id = Int32.Parse(ReadINI("left_wing_id", "wing_flaps", "-2"))
                tmpTCustomJetCFG.right_wing_id = Int32.Parse(ReadINI("right_wing_id", "wing_flaps", "-2"))
                tmpTCustomJetCFG.left_flap_id = Int32.Parse(ReadINI("left_flap_id", "wing_flaps", "-1"))
                tmpTCustomJetCFG.right_flap_id = Int32.Parse(ReadINI("right_flap_id", "wing_flaps", "-1"))
                tmpTCustomJetCFG.back_gears_r_id = Int32.Parse(ReadINI("back_gears_r_id", "wing_flaps", "-1"))
                tmpTCustomJetCFG.back_gears_l_id = Int32.Parse(ReadINI("back_gears_l_id", "wing_flaps", "-1"))
                tmpTCustomJetCFG.front_gears_r_id = Int32.Parse(ReadINI("front_gears_r_id", "wing_flaps", "-1"))
                tmpTCustomJetCFG.front_gears_l_id = Int32.Parse(ReadINI("front_gears_l_id", "wing_flaps", "-1"))
                tmpTCustomJetCFG.rudder_1_id = Int32.Parse(ReadINI("rudder_1_id", "wing_flaps", "-100"))
                tmpTCustomJetCFG.rudder_2_id = Int32.Parse(ReadINI("rudder_2_id", "wing_flaps", "-100"))
                tmpTCustomJetCFG.elevator_1_id = Int32.Parse(ReadINI("elevator_1_id", "wing_flaps", "-100"))
                tmpTCustomJetCFG.elevator_2_id = Int32.Parse(ReadINI("elevator_2_id", "wing_flaps", "-100"))
                tmpTCustomJetCFG.gears_closed_angle = Double.Parse(ReadINI("gears_closed_angle", "wing_flaps", "-1"))
                tmpTCustomJetCFG.gears_open_angle = Double.Parse(ReadINI("gears_open_angle", "wing_flaps", "-1"))
                tmpTCustomJetCFG.rudder_idle_angle = Double.Parse(ReadINI("rudder_idle_angle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.rudder_min_angle = Double.Parse(ReadINI("rudder_min_angle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.rudder_max_angle = Double.Parse(ReadINI("rudder_max_angle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.elevator_max_angle = Double.Parse(ReadINI("elevator_max_angle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.elevator_min_angle = Double.Parse(ReadINI("elevator_min_angle", "wing_flaps", "-100"))
                tmpTCustomJetCFG.elevator_idle_angle = Double.Parse(ReadINI("elevator_idle_angle", "wing_flaps", "-100"))

                writeDiv("wing_flaps")

                ' native game sounds
                'soundCannon, soundJetIdle, soundJetAccel, soundBombRelease, soundRocketMove
                If ReadINI("soundJetIdle", "sounds", "-1") = "-1" Then WriteINI("soundJetIdle", "sounds", "JET_DISTANT_WRAPPER")
                If ReadINI("soundJetAccel", "sounds", "-1") = "-1" Then WriteINI("soundJetAccel", "sounds", "VEHICLES_AMBIENT_JETS_MIDRANGE_PHASE_JET_1")
                If ReadINI("soundJetAccel2", "sounds", "-1") = "-1" Then WriteINI("soundJetAccel2", "sounds", "JETS_AMBIENT_IDLES_LIGHT_JET")
                If ReadINI("soundCannon", "sounds", "") = "" Then WriteINI("soundCannon", "sounds", "shotgun_fire")
                If ReadINI("soundBombRelease", "sounds", "") = "" Then WriteINI("soundBombRelease", "sounds", "COLLISIONS_COLLISIONS_BOMBER_JACKET_STRIKE_1")
                If ReadINI("soundRocketMove", "sounds", "") = "" Then WriteINI("soundRocketMove", "sounds", "GENERAL_WEAPONS_ROCKET_LOOP")

                tmpTCustomJetCFG.soundJetIdle = ReadINI("soundJetIdle", "sounds", "")
                tmpTCustomJetCFG.soundJetAccel = ReadINI("soundJetAccel", "sounds", "")
                tmpTCustomJetCFG.soundJetAccel2 = ReadINI("soundJetAccel2", "sounds", "")
                tmpTCustomJetCFG.soundCannon = ReadINI("soundCannon", "sounds", "")
                tmpTCustomJetCFG.soundBombRelease = ReadINI("soundBombRelease", "sounds", "")
                tmpTCustomJetCFG.soundRocketMove = ReadINI("soundRocketMove", "sounds", "")

                writeDiv("sounds")

                ' rockets/bombs
                For c As Int16 = 1 To 16
                    If ReadINI("enabled", "rocket_" & c.ToString, "-1") = "-1" Then WriteINI("enabled", "rocket_" & c.ToString, "0")
                    If ReadINI("visible_when_fired", "rocket_" & c.ToString, "-1") = "-1" Then WriteINI("visible_when_fired", "rocket_" & c.ToString, "1")
                    If ReadINI("visible_when_idle", "rocket_" & c.ToString, "-1") = "-1" Then WriteINI("visible_when_idle", "rocket_" & c.ToString, "0")
                    If ReadINI("is_bomb", "rocket_" & c.ToString, "-1") = "-1" Then WriteINI("is_bomb", "rocket_" & c.ToString, "0")
                    If ReadINI("model", "rocket_" & c.ToString, "") = "" Then WriteINI("model", "rocket_" & c.ToString, "cj_rpg_rocket")
                    If ReadINI("x", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("x", "rocket_" & c.ToString, "2.5")
                    If ReadINI("y", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("y", "rocket_" & c.ToString, "-3.0")
                    If ReadINI("z", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("z", "rocket_" & c.ToString, "-0.3")
                    If ReadINI("xr", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("xr", "rocket_" & c.ToString, "0")
                    If ReadINI("yr", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("yr", "rocket_" & c.ToString, "0")
                    If ReadINI("zr", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("zr", "rocket_" & c.ToString, "0")
                    If ReadINI("damage_against_jets", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("damage_against_jets", "rocket_" & c.ToString, "400")
                    If ReadINI("speed_multiplier", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("speed_multiplier", "rocket_" & c.ToString, "1.0")
                    If ReadINI("explosion_size", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("explosion_size", "rocket_" & c.ToString, "1.0")
                    If ReadINI("explosion_force", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("explosion_force", "rocket_" & c.ToString, "1.0")
                    If ReadINI("propulsor_effect_size", "rocket_" & c.ToString, "-100") = "-100" Then WriteINI("propulsor_effect_size", "rocket_" & c.ToString, "0.2")

                    ' create the rocket
                    'if ReadINI("enabled", "rocket_" & c.tostring, "-1") = "1" then
                        tmpRocket = New MR
                        tmpRocket.model_name = ReadINI("model", "rocket_" & c.ToString, "")

                        If tmpRocket.model_name <> "cj_rpg_rocket" Then
                            tmpRocket.rocket = World.CreateObject(tmpRocket.model_name, Player.Character.Position.Around(5) + Vector3.WorldUp * 100)
                        Else
                            tmpRocket.rocket = myRockets(c - 1)
                        End If

                        tmpRocket.enabled = ReadINI("enabled", "rocket_" & c.ToString, "-1") = "1"
                        tmpRocket.Hide(tmpRocket.rocket)
                        tmpRocket.xAttach = Double.Parse(ReadINI("x", "rocket_" & c.ToString, "-100"))
                        tmpRocket.yAttach = Double.Parse(ReadINI("y", "rocket_" & c.ToString, "-100"))
                        tmpRocket.zAttach = Double.Parse(ReadINI("z", "rocket_" & c.ToString, "-100"))
                        tmpRocket.xRotAttach = Double.Parse(ReadINI("xr", "rocket_" & c.ToString, "-100"))
                        tmpRocket.yRotAttach = Double.Parse(ReadINI("yr", "rocket_" & c.ToString, "-100"))
                        tmpRocket.zRotAttach = Double.Parse(ReadINI("zr", "rocket_" & c.ToString, "-100"))
                        tmpRocket.isBomb = ReadINI("is_bomb", "rocket_" & c.ToString, "-1") = "1"
                        tmpRocket.visible_fired = ReadINI("visible_when_fired", "rocket_" & c.ToString, "-1") = "1"
                        tmpRocket.visible_idle = ReadINI("visible_when_idle", "rocket_" & c.ToString, "-1") = "1"
                        tmpRocket.damage_against_jets = Double.Parse(ReadINI("damage_against_jets", "rocket_" & c.ToString, "-1"))
                        tmpRocket.speed_multiplier = Double.Parse(ReadINI("speed_multiplier", "rocket_" & c.ToString, "-1"))
                        tmpRocket.explosion_size = Double.Parse(ReadINI("explosion_size", "rocket_" & c.ToString, "-1"))
                        tmpRocket.explosion_force = Double.Parse(ReadINI("explosion_force", "rocket_" & c.ToString, "-1"))
                        tmpRocket.propulsor_effect_size = Double.Parse(ReadINI("propulsor_effect_size", "rocket_" & c.ToString, "-1"))
                        tmpTCustomJetCFG.MRL.Add(tmpRocket)
                    'end if

                    If c = 16 Then
                        writeDiv("rocket_" & c.ToString)
                    Else
                        writeDiv("rocket_" & c.ToString, ".")
                    End If
                Next

                tmpTCustomJetCFG.cannonCount = 0

                ' cannon
                For c As Int16 = 1 To 4
                    If ReadINI("enabled", "cannon_" & c.ToString, "-1") = "-1" Then WriteINI("enabled", "cannon_" & c.ToString, "0")
                    If ReadINI("x", "cannon_" & c.ToString, "-100") = "-100" Then WriteINI("x", "cannon_" & c.ToString, "0.85")
                    If ReadINI("y", "cannon_" & c.ToString, "-100") = "-100" Then WriteINI("y", "cannon_" & c.ToString, "2.0")
                    If ReadINI("z", "cannon_" & c.ToString, "-100") = "-100" Then WriteINI("z", "cannon_" & c.ToString, "-0.3")
                    If ReadINI("size", "cannon_" & c.ToString, "-100") = "-100" Then WriteINI("size", "cannon_" & c.ToString, "2.0")
                    If ReadINI("trace_size", "cannon_" & c.ToString, "-100") = "-100" Then WriteINI("trace_size", "cannon_" & c.ToString, "1.0")
                    If ReadINI("range", "cannon_" & c.ToString, "-100") = "-100" Then WriteINI("range", "cannon_" & c.ToString, "300")
                    If ReadINI("damage", "cannon_" & c.ToString, "-100") = "-100" Then WriteINI("damage", "cannon_" & c.ToString, "50")
                    If ReadINI("shootTime", "cannon_" & c.ToString, "-100") = "-100" Then
                        If c Mod 2 = 0 Then
                            WriteINI("shootTime", "cannon_" & c.ToString, "1")
                        Else
                            WriteINI("shootTime", "cannon_" & c.ToString, "2")
                        End If
                    End If
                    'if ReadINI("enabled", "cannon_" & c.tostring, "-1") = "1" then
                        tmpCannon = New cannon
                        tmpCannon.enabled = ReadINI("enabled", "cannon_" & c.ToString, "-1") = "1"
                        tmpCannon.offPosition.X = Double.Parse(ReadINI("x", "cannon_" & c.ToString, "-100"))
                        tmpCannon.offPosition.Y = Double.Parse(ReadINI("y", "cannon_" & c.ToString, "-100"))
                        tmpCannon.offPosition.Z = Double.Parse(ReadINI("z", "cannon_" & c.ToString, "-100"))
                        tmpCannon.size = Double.Parse(ReadINI("size", "cannon_" & c.ToString, "-100"))
                        tmpCannon.trace_size = Double.Parse(ReadINI("trace_size", "cannon_" & c.ToString, "-100"))
                        tmpCannon.range = Double.Parse(ReadINI("range", "cannon_" & c.ToString, "-100"))
                        tmpCannon.damage = Int32.Parse(ReadINI("damage", "cannon_" & c.ToString, "-100"))
                        tmpCannon.shootTime = Int32.Parse(ReadINI("shootTime", "cannon_" & c.ToString, "-100"))
                        tmpTCustomJetCFG.cannList.Add(tmpCannon)
                    'end if

                    If c = 4 Then
                        writeDiv("cannon_" & c.ToString)
                    Else
                        writeDiv("cannon_" & c.ToString, ".")
                    End If
                Next

                For Each c As cannon In tmpTCustomJetCFG.cannList
                    If c.enabled AndAlso (c.shootTime > tmpTCustomJetCFG.cannonCount) Then tmpTCustomJetCFG.cannonCount = c.shootTime
                Next

                TCustomJetCFGList.Add(tmpTCustomJetCFG)
            End If
        Next
    End Sub

    Private Sub loadJetAquirementPos()
        iniFile = ".\Scripts\JetFiles\Jet_Spawn.ini"
        checkIniExists()

        ' jet aquirement positions
        For c As Int16 = 1 To 10
            If ReadINI("enabled", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("enabled", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("display_name", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("display_name", "jet_aquirement_" & c.ToString, "Jet")
            If ReadINI("showOnMap", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("showOnMap", "jet_aquirement_" & c.ToString, "1")
            If ReadINI("checkPVisible", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("checkPVisible", "jet_aquirement_" & c.ToString, "1")
            If ReadINI("autoCreateJet", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("autoCreateJet", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("jetModel", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("jetModel", "jet_aquirement_" & c.ToString, "airtug")
            If ReadINI("check_x", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("check_x", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("check_y", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("check_y", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("check_z", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("check_z", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("jet_x", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("jet_x", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("jet_y", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("jet_y", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("jet_z", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("jet_z", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("diameter", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("diameter", "jet_aquirement_" & c.ToString, "3")
            If ReadINI("heading", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("heading", "jet_aquirement_" & c.ToString, "0")
            If ReadINI("cpAlpha", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("cpAlpha", "jet_aquirement_" & c.ToString, "100")
            If ReadINI("cpRcolor", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("cpRcolor", "jet_aquirement_" & c.ToString, "255")
            If ReadINI("cpGcolor", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("cpGcolor", "jet_aquirement_" & c.ToString, "255")
            If ReadINI("cpBcolor", "jet_aquirement_" & c.ToString, "") = "" Then WriteINI("cpBcolor", "jet_aquirement_" & c.ToString, "255")

            writeDiv("jet_aquirement_" & c.ToString)

            If ReadINI("enabled", "jet_aquirement_" & c.ToString, "") = "1" Then
                tmpTJetAP = New TJetAP
                tmpTJetAP.display_name = ReadINI("display_name", "jet_aquirement_" & c.ToString, "")
                tmpTJetAP.showOnMap = ReadINI("showOnMap", "jet_aquirement_" & c.ToString, "1") = "1"
                tmpTJetAP.checkPVisible = ReadINI("checkPVisible", "jet_aquirement_" & c.ToString, "1") = "1"
                tmpTJetAP.autoCreateJet = ReadINI("autoCreateJet", "jet_aquirement_" & c.ToString, "0") = "1"
                tmpTJetAP.checkPos.X = Double.Parse(ReadINI("check_x", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.checkPos.Y = Double.Parse(ReadINI("check_y", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.checkPos.Z = Double.Parse(ReadINI("check_z", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.jetPos.X = Double.Parse(ReadINI("jet_x", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.jetPos.Y = Double.Parse(ReadINI("jet_y", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.jetPos.Z = Double.Parse(ReadINI("jet_z", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.jetPos = tmpTJetAP.jetPos.ToGround
                tmpTJetAP.diameter = Double.Parse(ReadINI("diameter", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.heading = Double.Parse(ReadINI("heading", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.cpAlpha = Double.Parse(ReadINI("cpAlpha", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.cpRcolor = Double.Parse(ReadINI("cpRcolor", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.cpGcolor = Double.Parse(ReadINI("cpGcolor", "jet_aquirement_" & c.ToString, "0"))
                tmpTJetAP.cpBcolor = Double.Parse(ReadINI("cpBcolor", "jet_aquirement_" & c.ToString, "0"))

                tmpTJetAP.cp.Visible = tmpTJetAP.checkPVisible

                If ReadINI("jetModel", "jet_aquirement_" & c.ToString, "") <> "" Then _
                    tmpTJetAP.jetModel = New Model(ReadINI("jetModel", "jet_aquirement_" & c.ToString, ""))

                If tmpTJetAP.showOnMap Then
                    tmpTJetAP.tblip = Blip.AddBlip(tmpTJetAP.checkPos)

                    If Exists(tmpTJetAP.tblip) Then
                        tmpTJetAP.tblip.SetColorRGB(Color.FromArgb(0, 255, 255, 255))
                        tmpTJetAP.tblip.Color = BlipColor.White
                        tmpTJetAP.tblip.ShowOnlyWhenNear = True
                        tmpTJetAP.tblip.Name = tmpTJetAP.display_name
                    End If
                End If

                TJetAPList.Add(tmpTJetAP)
            End If
        Next
    End Sub

    Private Function random(ByVal min As Int32, ByVal max As Int32)
        Dim rnd As Random = New Random(System.DateTime.Now.Millisecond)
        random = rnd.Next(min, max)
    End Function

    Private Declare Auto Function GetPrivateProfileString Lib "Kernel32" _
        (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As StringBuilder, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

    Private Declare Auto Function WritePrivateProfileString Lib "Kernel32" _
        (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lpFileName As String) As Integer

    Private Function ReadINI(ByVal key_name As String, ByVal section_name As String, ByVal default_value As String) As String
        Const MAX_LENGTH As Integer = 500
        Dim string_builder As New StringBuilder(MAX_LENGTH)

        GetPrivateProfileString(section_name, key_name, default_value, string_builder, MAX_LENGTH, iniFile)

        Return string_builder.ToString()
    End Function

    Private Sub WriteINI(ByVal key_name As String, ByVal section_name As String, ByVal value As String)
        WritePrivateProfileString(section_name, key_name, value, iniFile)
    End Sub

    Private Sub writeDiv(ByVal section_name As String, Optional ByVal sChar As String = "-")
        If ReadINI("div", section_name, "") = "" Then
            If sChar = "-" Then
                WriteINI("div", section_name, "===============================================div")
            Else
                WriteINI("div", section_name, "...............................................div")
            End If
        End If
    End Sub

    Private Sub checkIniExists()
        If Not File.Exists(iniFile) Then
            File.CreateText(iniFile).Dispose()

            Wait(100)
        End If
    End Sub
End Class